/*
 * Decompiled with CFR 0.152.
 */
package cormoran.pepper.parquet;

import cormoran.pepper.avro.IBinaryToAvroStream;
import cormoran.pepper.io.PepperFileHelper;
import cormoran.pepper.parquet.ParquetStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetBytesToStream
implements IBinaryToAvroStream {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ParquetBytesToStream.class);
    protected final boolean deleteOnExit;

    public ParquetBytesToStream() {
        this(true);
    }

    protected ParquetBytesToStream(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    protected URI persist(InputStream inputStream) throws IOException {
        Path tmp = this.pathWhereToDumpBytes();
        LOGGER.debug("We persist a parquet InputStream into {}", (Object)tmp);
        Files.copy(inputStream, tmp, StandardCopyOption.REPLACE_EXISTING);
        return tmp.toUri();
    }

    protected Path pathWhereToDumpBytes() throws IOException {
        return PepperFileHelper.createTempPath((String)this.getClass().getSimpleName(), (String)".parquet", (boolean)true);
    }

    public Stream<GenericRecord> stream(InputStream inputStream) throws IOException {
        URI uri = this.persist(inputStream);
        return new ParquetStreamFactory().stream(uri);
    }
}

