/*
 * Decompiled with CFR 0.152.
 */
package cormoran.pepper.parquet;

import cormoran.pepper.parquet.ParquetBytesToStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunParquetVisualizer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RunParquetVisualizer.class);

    protected RunParquetVisualizer() {
    }

    public static void main(String[] args) throws IOException {
        Path path = RunParquetVisualizer.getParquetFile(args);
        AtomicLong rowIndex = new AtomicLong();
        new ParquetBytesToStream().stream(path.toUri().toURL().openStream()).forEach(row -> LOGGER.info("row #{}: {}", (Object)rowIndex.getAndIncrement(), row));
    }

    protected static Path getParquetFile(String ... args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("We expect at least one argument being the path top the parquet file");
        }
        String pathAsString = args[0];
        Path path = Paths.get(pathAsString, new String[0]);
        if (!path.toFile().isFile()) {
            throw new IllegalArgumentException(path + " is not a file");
        }
        return path;
    }
}

