/*
 * Decompiled with CFR 0.152.
 */
package cormoran.pepper.parquet;

import cormoran.pepper.io.PepperFileHelper;
import cormoran.pepper.parquet.ParquetBytesToStream;
import cormoran.pepper.parquet.ParquetStreamFactory;
import cormoran.pepper.parquet.RunParquetVisualizer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunParquetFilter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RunParquetFilter.class);
    private static final int DEFAULT_NB_ROWS_TO_SHOW = 10;

    protected RunParquetFilter() {
    }

    public static void main(String[] args) throws IOException {
        Path path = RunParquetVisualizer.getParquetFile(args);
        URI output = args.length >= 2 ? Paths.get(args[1], new String[0]).toUri() : PepperFileHelper.createTempPath((String)"RunParquetFilter", (String)".parquet", (boolean)false).toUri();
        int limit = Integer.getInteger("pepper.limit", 10);
        ParquetBytesToStream parquetBytesToStream = new ParquetBytesToStream();
        LOGGER.info("About to read rows from {}", (Object)path);
        Stream<GenericRecord> streamToWrite = parquetBytesToStream.stream(path.toUri().toURL().openStream()).limit(limit);
        LOGGER.info("About to write rows to {}", (Object)output);
        new ParquetStreamFactory().serialize(output, streamToWrite);
    }
}

