/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.artistic.mosaic;

import java.awt.Color;
import java.awt.Graphics;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Mosaic
extends MarvinAbstractImagePlugin {
    private static final String SQUARES = "squares";
    private static final String TRIANGLES = "triangles";
    private int width;
    private String shape;
    private boolean border;
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private MarvinPerformanceMeter performanceMeter;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("width", (Object)6);
        this.attributes.set("shape", (Object)SQUARES);
        this.attributes.set("border", (Object)true);
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblWidth", "Tile witdh:");
            this.attributesPanel.addTextField("txtwidth", "width", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblWidth", "Format:");
            this.attributesPanel.addComboBox("combShape", "shape", new Object[]{SQUARES, TRIANGLES}, this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblWidth", "Edge:");
            this.attributesPanel.addComboBox("combBorder", "border", new Object[]{true, false}, this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean a_previewMode) {
        this.width = (Integer)this.attributes.get("width");
        this.shape = (String)this.attributes.get("shape");
        this.border = (Boolean)this.attributes.get("border");
        Graphics l_graphics = imageOut.getBufferedImage().getGraphics();
        this.performanceMeter.enableProgressBar("Mosaic", imageIn.getHeight() * this.width);
        if (this.shape.equals(SQUARES)) {
            this.squaresMosaic(this.width, this.border, l_graphics, imageIn);
        } else if (this.shape.equals(TRIANGLES)) {
            this.trianglesMosaic(this.width, this.border, l_graphics, imageIn);
        }
        imageOut.updateColorArray();
        this.performanceMeter.finish();
    }

    private void squaresMosaic(int width, boolean border, Graphics graphics, MarvinImage image) {
        for (int y = 0; y < image.getHeight(); y += width) {
            for (int x = 0; x < image.getWidth(); x += width) {
                Color l_color = this.getSquareColor(x, y, image);
                graphics.setColor(l_color);
                graphics.fillRect(x, y, width, width);
                if (!border) continue;
                graphics.setColor(Color.black);
                graphics.drawRect(x, y, width, width);
            }
            this.performanceMeter.stepsFinished(image.getWidth());
        }
    }

    private void trianglesMosaic(int width, boolean border, Graphics graphics, MarvinImage image) {
        int t = -1;
        boolean l_aux = true;
        if (image.getWidth() / width % 2 == 0 && image.getWidth() % width == 0 || image.getWidth() / width % 2 == 1 && image.getWidth() % width != 0) {
            l_aux = false;
        }
        for (int y = 0; y < image.getHeight(); y += width) {
            for (int x = 0; x < image.getWidth(); x += width) {
                Color l_colorT2;
                Color l_colorT1;
                if (t == -1) {
                    l_colorT1 = this.getTriangleColor(x, y, 0, image);
                    l_colorT2 = this.getTriangleColor(x, y, 1, image);
                    graphics.setColor(l_colorT1);
                    graphics.fillPolygon(new int[]{x, x + width, x}, new int[]{y, y, y + width}, 3);
                    if (border) {
                        graphics.setColor(Color.black);
                        graphics.drawPolygon(new int[]{x, x + width, x}, new int[]{y, y, y + width}, 3);
                    }
                    graphics.setColor(l_colorT2);
                    graphics.fillPolygon(new int[]{x + width, x + width, x}, new int[]{y, y + width, y + width}, 3);
                    if (border) {
                        graphics.setColor(Color.black);
                        graphics.drawPolygon(new int[]{x + width, x + width, x}, new int[]{y, y + width, y + width}, 3);
                    }
                } else {
                    l_colorT1 = this.getTriangleColor(x, y, 2, image);
                    l_colorT2 = this.getTriangleColor(x, y, 3, image);
                    graphics.setColor(l_colorT1);
                    graphics.fillPolygon(new int[]{x, x + width, x + width}, new int[]{y, y, y + width}, 3);
                    if (border) {
                        graphics.setColor(Color.black);
                        graphics.drawPolygon(new int[]{x, x + width, x + width}, new int[]{y, y, y + width}, 3);
                    }
                    graphics.setColor(l_colorT2);
                    graphics.fillPolygon(new int[]{x, x + width, x}, new int[]{y, y + width, y + width}, 3);
                    if (border) {
                        graphics.setColor(Color.black);
                        graphics.drawPolygon(new int[]{x, x + width, x}, new int[]{y, y + width, y + width}, 3);
                    }
                }
                this.performanceMeter.stepsFinished(image.getWidth());
                t *= -1;
            }
            if (!l_aux) continue;
            t *= -1;
        }
    }

    private Color getSquareColor(int aX, int aY, MarvinImage image) {
        int l_red = -1;
        int l_green = -1;
        int l_blue = -1;
        for (int y = 0; y < this.width; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (aX + x <= 0 || aX + x >= image.getWidth() || aY + y <= 0 || aY + y >= image.getHeight()) continue;
                if (l_red == -1) {
                    l_red = image.getIntComponent0(aX + x, aY + y);
                    l_green = image.getIntComponent1(aX + x, aY + y);
                    l_blue = image.getIntComponent2(aX + x, aY + y);
                    continue;
                }
                l_red = (l_red + image.getIntComponent0(aX + x, aY + y)) / 2;
                l_green = (l_green + image.getIntComponent1(aX + x, aY + y)) / 2;
                l_blue = (l_blue + image.getIntComponent2(aX + x, aY + y)) / 2;
            }
        }
        return new Color(l_red, l_green, l_blue);
    }

    private Color getTriangleColor(int aX, int aY, int tringlePos, MarvinImage image) {
        int l_red = -1;
        int l_green = -1;
        int l_blue = -1;
        int l_xInitial = 0;
        int l_xOffSet = 0;
        int l_xOffSetInc = 0;
        int l_xInitalInc = 0;
        switch (tringlePos) {
            case 0: {
                l_xInitial = 1;
                l_xOffSet = this.width;
                l_xOffSetInc = -1;
                l_xInitalInc = 0;
                break;
            }
            case 1: {
                l_xInitial = this.width - 1;
                l_xOffSet = this.width;
                l_xOffSetInc = 0;
                l_xInitalInc = -1;
                break;
            }
            case 2: {
                l_xInitial = 1;
                l_xOffSet = this.width;
                l_xOffSetInc = 0;
                l_xInitalInc = 1;
                break;
            }
            case 3: {
                l_xInitial = 1;
                l_xOffSet = 1;
                l_xOffSetInc = 1;
                l_xInitalInc = 0;
            }
        }
        int x = l_xInitial;
        int y = 0;
        for (int w = 0; w < this.width - 1; ++w) {
            while (x < l_xOffSet) {
                if (aX + x > 0 && aX + x < image.getWidth() && aY + y > 0 && aY + y < image.getHeight()) {
                    if (l_red == -1) {
                        l_red = image.getIntComponent0(aX + x, aY + y);
                        l_green = image.getIntComponent1(aX + x, aY + y);
                        l_blue = image.getIntComponent2(aX + x, aY + y);
                    } else {
                        l_red = (l_red + image.getIntComponent0(aX + x, aY + y)) / 2;
                        l_green = (l_green + image.getIntComponent1(aX + x, aY + y)) / 2;
                        l_blue = (l_blue + image.getIntComponent2(aX + x, aY + y)) / 2;
                    }
                }
                ++x;
            }
            l_xOffSet += l_xOffSetInc;
            x = l_xInitial += l_xInitalInc;
            ++y;
        }
        if (l_red == -1) {
            l_red = 0;
        }
        if (l_green == -1) {
            l_green = 0;
        }
        if (l_blue == -1) {
            l_blue = 0;
        }
        return new Color(l_red, l_green, l_blue);
    }
}

