/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.background.determineSceneBackground;

import java.util.ArrayList;
import java.util.List;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class DetermineSceneBackground
extends MarvinAbstractImagePlugin {
    private int threshold;

    public void load() {
        this.setAttribute("threshold", 30);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
    }

    public void process(List<MarvinImage> images, MarvinImage imageOut) {
        this.threshold = (Integer)this.getAttribute("threshold");
        MarvinImage image0 = images.get(0);
        for (int y = 0; y < image0.getHeight(); ++y) {
            for (int x = 0; x < image0.getWidth(); ++x) {
                imageOut.setIntColor(x, y, this.getBackgroundPixel(x, y, images, this.threshold));
            }
        }
    }

    private int getBackgroundPixel(int x, int y, List<MarvinImage> images, int threshold) {
        ArrayList<Integer[]> colors = new ArrayList<Integer[]>();
        for (MarvinImage img : images) {
            Integer[] c = new Integer[]{img.getIntComponent0(x, y), img.getIntComponent1(x, y), img.getIntComponent2(x, y), 0};
            if (colors.isEmpty()) {
                colors.add(c);
                continue;
            }
            boolean found = false;
            for (Integer[] c2 : colors) {
                if (!((double)Math.abs(c2[0] - c[0]) < (double)threshold * 0.3) || !((double)Math.abs(c2[1] - c[1]) < (double)threshold * 0.3) || !((double)Math.abs(c2[2] - c[2]) < (double)threshold * 0.3)) continue;
                c2[0] = (c2[0] + c[0]) / 2;
                c2[1] = (c2[1] + c[1]) / 2;
                c2[2] = (c2[2] + c[2]) / 2;
                Integer[] integerArray = c2;
                Integer n = integerArray[3];
                Integer n2 = integerArray[3] = Integer.valueOf(integerArray[3] + 1);
                found = true;
                break;
            }
            if (found) continue;
            colors.add(c);
        }
        int max = -1;
        int maxIndex = 0;
        Integer[] c2 = null;
        for (int i = 0; i < colors.size(); ++i) {
            c2 = (Integer[])colors.get(i);
            if (max != -1 && c2[3] <= max) continue;
            max = c2[3];
            maxIndex = i;
        }
        c2 = (Integer[])colors.get(maxIndex);
        return 255 + (c2[0] << 16) + (c2[1] << 8) + c2[2];
    }
}

