/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.edge.prewitt;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.math.MarvinMath;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.convolution.Convolution;

public class Prewitt
extends MarvinAbstractImagePlugin {
    double[][] matrixPrewittX = new double[][]{{1.0, 0.0, -1.0}, {1.0, 0.0, -1.0}, {1.0, 0.0, -1.0}};
    double[][] matrixPrewittY = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -1.0, -1.0}};
    private MarvinImagePlugin convolution;

    public void load() {
        this.convolution = new Convolution();
        this.convolution.load();
        this.setAttribute("intensity", 1.0);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        double intensity = (Double)this.getAttribute("intensity");
        if (intensity == 1.0) {
            this.convolution.setAttribute("matrix", (Object)this.matrixPrewittX);
            this.convolution.process(imageIn, imageOut, null, mask, previewMode);
            this.convolution.setAttribute("matrix", (Object)this.matrixPrewittY);
            this.convolution.process(imageIn, imageOut, null, mask, previewMode);
        } else {
            this.convolution.setAttribute("matrix", (Object)MarvinMath.scaleMatrix((double[][])this.matrixPrewittX, (double)intensity));
            this.convolution.process(imageIn, imageOut, null, mask, previewMode);
            this.convolution.setAttribute("matrix", (Object)MarvinMath.scaleMatrix((double[][])this.matrixPrewittY, (double)intensity));
            this.convolution.process(imageIn, imageOut, null, mask, previewMode);
        }
    }
}

