/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.halftone.circles;

import java.awt.Color;
import java.awt.Graphics;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class Circles
extends MarvinAbstractImagePlugin {
    private int circleWidth;
    private int shift;
    private int circlesDistance;
    MarvinPerformanceMeter performanceMeter;
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("circleWidth", (Object)6);
        this.attributes.set("shift", (Object)0);
        this.attributes.set("circlesDistance", (Object)0);
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblWidth", "Circle width:");
            this.attributesPanel.addTextField("txtCircleWidth", "circleWidth", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblShift", "Line Shift:");
            this.attributesPanel.addTextField("txtShift", "shift", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblDistance", "Circles distance:");
            this.attributesPanel.addTextField("lblCirclesDistance", "circlesDistance", this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        this.circleWidth = (Integer)this.attributes.get("circleWidth");
        this.shift = (Integer)this.attributes.get("shift");
        this.circlesDistance = (Integer)this.attributes.get("circlesDistance");
        Graphics l_graphics = a_imageOut.getBufferedImage().getGraphics();
        GrayScale l_filter = new GrayScale();
        l_filter.load();
        l_filter.process(a_imageIn, a_imageIn, a_attributesOut, a_mask, a_previewMode);
        this.performanceMeter.enableProgressBar("Halftone - Circles", a_imageIn.getHeight() / (this.circleWidth + this.circlesDistance) * (a_imageIn.getWidth() / (this.circleWidth + this.circlesDistance)));
        boolean[][] l_arrMask = a_mask.getMask();
        int l_dif = 0;
        for (int y = 0; y < a_imageIn.getHeight(); y += this.circleWidth + this.circlesDistance) {
            for (int x = 0 + l_dif; x < a_imageIn.getWidth(); x += this.circleWidth + this.circlesDistance) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                double l_intensity = this.getSquareIntensity(x, y, a_imageIn);
                l_graphics.setColor(Color.white);
                l_graphics.fillRect(x, y, this.circleWidth + this.circlesDistance, this.circleWidth + this.circlesDistance);
                l_graphics.setColor(Color.black);
                l_graphics.fillArc((int)((double)x + ((double)this.circleWidth - (l_intensity += 1.0 / (double)this.circleWidth) * (double)this.circleWidth) / 2.0), (int)((double)y + ((double)this.circleWidth - l_intensity * (double)this.circleWidth) / 2.0), (int)(l_intensity * (double)this.circleWidth), (int)(l_intensity * (double)this.circleWidth), 1, 360);
            }
            l_dif = (l_dif + this.shift) % this.circleWidth;
            this.performanceMeter.stepsFinished(a_imageIn.getWidth() / (this.circleWidth + this.circlesDistance));
        }
        a_imageOut.updateColorArray();
        this.performanceMeter.finish();
    }

    private double getSquareIntensity(int a_x, int a_y, MarvinImage image) {
        double l_totalValue = 0.0;
        for (int y = 0; y < this.circleWidth; ++y) {
            for (int x = 0; x < this.circleWidth; ++x) {
                if (a_x + x <= 0 || a_x + x >= image.getWidth() || a_y + y <= 0 || a_y + y >= image.getHeight()) continue;
                l_totalValue += (double)(255 - image.getIntComponent0(a_x + x, a_y + y));
            }
        }
        return l_totalValue / (double)(this.circleWidth * this.circleWidth * 255);
    }
}

