/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.morphological.erosion;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Erosion
extends MarvinAbstractImagePlugin {
    private boolean[][] matrix;

    public void load() {
        this.setAttribute("matrix", this.matrix);
    }

    public void process(MarvinImage imgIn, MarvinImage imgOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        this.matrix = (boolean[][])this.getAttribute("matrix");
        if (imgIn.getColorModel() == 1 && this.matrix != null) {
            MarvinImage.copyColorArray((MarvinImage)imgIn, (MarvinImage)imgOut);
            for (int y = 0; y < imgIn.getHeight(); ++y) {
                for (int x = 0; x < imgIn.getWidth(); ++x) {
                    this.applyMatrix(x, y, this.matrix, imgIn, imgOut);
                }
            }
        }
    }

    private void applyMatrix(int x, int y, boolean[][] matrix, MarvinImage imgIn, MarvinImage imgOut) {
        int xC = matrix[0].length / 2;
        int yC = matrix.length / 2;
        if (!imgIn.getBinaryColor(x, y)) {
            for (int i = 0; i < matrix.length; ++i) {
                for (int j = 0; j < matrix[0].length; ++j) {
                    if (i == yC && j == xC || !matrix[i][j]) continue;
                    int nx = x + (j - xC);
                    int ny = y + (i - yC);
                    if (nx < 0 || nx >= imgOut.getWidth() || ny < 0 || ny >= imgOut.getHeight()) continue;
                    imgOut.setBinaryColor(nx, ny, false);
                }
            }
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

