/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.pattern.correlation;

import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.util.MarvinFileChooser;

public class Correlation
extends MarvinAbstractImagePlugin {
    private MarvinImage img_padrao;
    private MarvinImage img_teste;
    private MarvinPerformanceMeter performanceMeter;
    private double somaX;
    private double somaY;
    private double somaXY;
    private double n;
    private double somaX2;
    private double somaY2;
    private double acima;
    private double abaixo;
    private double r;
    private double somaX2R;
    private double somaY2R;
    private String novaImagem;
    private boolean modoAnalise = false;
    private double cr;

    public void setNovaImagem(String novaImagem) {
        this.novaImagem = novaImagem;
    }

    public void setModoAnalise(boolean b) {
        this.modoAnalise = b;
    }

    public double getCr() {
        return this.cr;
    }

    public void load() {
        if (!this.modoAnalise) {
            this.performanceMeter = new MarvinPerformanceMeter();
            this.process(this.getImagePanel().getImage(), null, null, MarvinImageMask.NULL_MASK, true);
        }
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        this.img_padrao = a_imageIn;
        try {
            if (!this.modoAnalise) {
                this.novaImagem = MarvinFileChooser.select(null, (boolean)true, (int)0);
            }
            this.img_teste = new MarvinImage(ImageIO.read(new File(this.novaImagem)));
        }
        catch (Exception e) {
            System.out.println("Error while selecting image");
        }
        if (this.img_teste.getWidth() == a_imageIn.getWidth() && this.img_teste.getHeight() == a_imageIn.getHeight()) {
            int y;
            int x;
            if (!this.modoAnalise) {
                this.performanceMeter.start("Correlation");
                this.performanceMeter.enableProgressBar("Correlation", 5 * (this.img_padrao.getWidth() * this.img_padrao.getHeight()));
            }
            this.n = this.img_padrao.getWidth() * this.img_padrao.getHeight();
            if (!this.modoAnalise) {
                this.performanceMeter.startEvent("Add X");
            }
            this.somaX = 0.0;
            for (x = 1; x < this.img_padrao.getWidth() - 1; ++x) {
                for (y = 1; y < this.img_padrao.getHeight() - 1; ++y) {
                    this.somaX += (double)this.img_padrao.getIntComponent0(x, y);
                }
                if (this.modoAnalise) continue;
                this.performanceMeter.stepsFinished(a_imageIn.getHeight());
                this.performanceMeter.incProgressBar(a_imageIn.getHeight());
            }
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
            }
            if (!this.modoAnalise) {
                this.performanceMeter.startEvent("Add Y");
            }
            this.somaY = 0.0;
            for (x = 1; x < this.img_teste.getWidth() - 1; ++x) {
                for (y = 1; y < this.img_teste.getHeight() - 1; ++y) {
                    this.somaY += (double)this.img_teste.getIntComponent0(x, y);
                }
                if (this.modoAnalise) continue;
                this.performanceMeter.stepsFinished(a_imageIn.getHeight());
                this.performanceMeter.incProgressBar(a_imageIn.getHeight());
            }
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
            }
            if (!this.modoAnalise) {
                this.performanceMeter.startEvent("Add XR");
            }
            this.somaX = 0.0;
            for (x = 1; x < this.img_padrao.getWidth() - 1; ++x) {
                for (y = 1; y < this.img_padrao.getHeight() - 1; ++y) {
                    this.somaX2R += Math.pow(this.img_padrao.getIntComponent0(x, y), 2.0);
                }
                if (this.modoAnalise) continue;
                this.performanceMeter.stepsFinished(a_imageIn.getHeight());
                this.performanceMeter.incProgressBar(a_imageIn.getHeight());
            }
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
                this.performanceMeter.startEvent("Add XR");
            }
            this.somaY = 0.0;
            for (x = 1; x < this.img_teste.getWidth() - 1; ++x) {
                for (y = 1; y < this.img_teste.getHeight() - 1; ++y) {
                    this.somaY2R += Math.pow(this.img_teste.getIntComponent0(x, y), 2.0);
                }
                if (this.modoAnalise) continue;
                this.performanceMeter.stepsFinished(a_imageIn.getHeight());
                this.performanceMeter.incProgressBar(a_imageIn.getHeight());
            }
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
                this.performanceMeter.startEvent("Add z y");
            }
            for (x = 1; x < this.img_teste.getWidth() - 1; ++x) {
                for (y = 1; y < this.img_teste.getHeight() - 1; ++y) {
                    this.somaXY += (double)(this.img_teste.getIntComponent0(x, y) * this.img_padrao.getIntComponent0(x, y));
                }
                if (this.modoAnalise) continue;
                this.performanceMeter.stepsFinished(a_imageIn.getHeight());
                this.performanceMeter.incProgressBar(a_imageIn.getHeight());
            }
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
                this.performanceMeter.startEvent("Adding all");
            }
            this.somaX2 = Math.sqrt(this.somaX);
            this.somaY2 = Math.sqrt(this.somaY);
            this.acima = this.n * this.somaXY - this.somaX * this.somaY;
            this.abaixo = Math.sqrt(this.n * this.somaX2R - this.somaX2) * Math.sqrt(this.n * this.somaY2R - this.somaY2);
            this.r = this.acima / this.abaixo;
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
                this.performanceMeter.finish();
            }
            this.cr = this.r;
            DecimalFormat myFormatter = new DecimalFormat("##.#");
            String output = myFormatter.format(this.r);
            if (!this.modoAnalise) {
                this.performanceMeter.finishEvent();
                this.performanceMeter.finish();
            }
            if (a_previewMode) {
                JOptionPane.showMessageDialog(null, "The correlation is: " + this.cr);
            }
        } else if (!this.modoAnalise) {
            JOptionPane.showMessageDialog(null, "The image have to the same size");
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

