/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.pattern.findSubimage;

import java.util.ArrayList;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.image.MarvinSegment;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class FindSubimage
extends MarvinAbstractImagePlugin {
    public void load() {
        this.setAttribute("similarity", 1.0);
        this.setAttribute("findAll", true);
        this.setAttribute("startX", 0);
        this.setAttribute("startY", 0);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
        ArrayList<MarvinSegment> segments = new ArrayList<MarvinSegment>();
        Object o = this.getAttribute("subimage");
        Double similarity = (Double)this.getAttribute("similarity");
        Boolean findAll = (Boolean)this.getAttribute("findAll");
        Integer startX = (Integer)this.getAttribute("startX");
        Integer startY = (Integer)this.getAttribute("startY");
        if (o != null) {
            MarvinImage subimage = (MarvinImage)o;
            int subImagePixels = subimage.getWidth() * subimage.getHeight();
            boolean[][] processed = new boolean[imageIn.getWidth()][imageIn.getHeight()];
            block0: for (int y = startY.intValue(); y < imageIn.getHeight(); ++y) {
                for (int x = startX.intValue(); x < imageIn.getWidth(); ++x) {
                    int j;
                    int i;
                    boolean match;
                    block12: {
                        if (processed[x][y]) continue;
                        int notMatched = 0;
                        match = true;
                        if (y + subimage.getHeight() < imageIn.getHeight() && x + subimage.getWidth() < imageIn.getWidth()) {
                            for (i = 0; i < subimage.getHeight(); ++i) {
                                for (j = 0; j < subimage.getWidth(); ++j) {
                                    if (processed[x + j][y + i]) {
                                        match = false;
                                    } else {
                                        int r1 = imageIn.getIntComponent0(x + j, y + i);
                                        int g1 = imageIn.getIntComponent1(x + j, y + i);
                                        int b1 = imageIn.getIntComponent2(x + j, y + i);
                                        int r2 = subimage.getIntComponent0(j, i);
                                        int g2 = subimage.getIntComponent1(j, i);
                                        int b2 = subimage.getIntComponent2(j, i);
                                        if (Math.abs(r1 - r2) <= 5 && Math.abs(g1 - g2) <= 5 && Math.abs(b1 - b2) <= 5 || !((double)(++notMatched) > (1.0 - similarity) * (double)subImagePixels)) continue;
                                        match = false;
                                    }
                                    break block12;
                                }
                            }
                        } else {
                            match = false;
                        }
                    }
                    if (!match) continue;
                    segments.add(new MarvinSegment(x, y, x + subimage.getWidth(), y + subimage.getHeight()));
                    if (!findAll.booleanValue()) break block0;
                    for (i = 0; i < subimage.getHeight(); ++i) {
                        for (j = 0; j < subimage.getWidth(); ++j) {
                            processed[x + j][y + i] = true;
                        }
                    }
                }
            }
        }
        if (attrOut != null) {
            attrOut.set("matches", segments);
        }
    }
}

