/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.pattern.harrisPlessey;

import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.segmentation.crop.Crop;

public class HarrisPlessey
extends MarvinAbstractImagePlugin {
    MarvinPerformanceMeter performanceMeter;
    private double Gx = 0.0;
    private double Gy = 0.0;
    private double A = 0.0;
    private double B = 0.0;
    private double C = 0.0;
    private double th = 1.7981439005E15;
    private double E = 0.0;
    private double k = 0.2;
    private double det = 0.0;
    private double trace = 0.0;
    private int[][] cantos;
    private int numeroCantos;
    private int rn;
    private int gn;
    private int bn;
    private int[][] gx;
    private int[][] gy;
    private int r;
    private int g;
    private int b;
    private int[] mul8gx;
    private int[] mul8gy;
    private String path = null;
    private boolean padrao;
    private boolean modoAnalise;
    private MarvinImagePlugin crop;

    public void load() {
        this.performanceMeter = new MarvinPerformanceMeter();
        this.crop = new Crop();
        this.crop.load();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int y;
        int x;
        int b;
        int r;
        int y2;
        int x2;
        if (a_previewMode || this.modoAnalise) {
            File[] tmpFiles;
            this.path = "";
            File dir = new File("pattern/tmp/");
            boolean trf = dir.delete();
            if (!trf && (tmpFiles = dir.listFiles()) != null) {
                for (int a = 0; a < tmpFiles.length; ++a) {
                    boolean bl = tmpFiles[a].delete();
                }
            }
            dir.mkdir();
        } else {
            this.path = JOptionPane.showInputDialog(null, "", "Type the class of this image", 3);
        }
        int l_processSteps = 0;
        l_processSteps += a_imageIn.getWidth() * a_imageIn.getHeight() * 2;
        l_processSteps += (a_imageIn.getWidth() - 2) * (a_imageIn.getHeight() - 2);
        l_processSteps += (a_imageIn.getWidth() - 3) * (a_imageIn.getHeight() - 3);
        this.performanceMeter.start("InterestPoint");
        this.performanceMeter.enableProgressBar("InterestPoint", l_processSteps += a_imageIn.getWidth() - 2);
        this.performanceMeter.startEvent("Gray scale");
        for (x2 = 0; x2 < a_imageIn.getWidth(); ++x2) {
            for (y2 = 0; y2 < a_imageIn.getHeight(); ++y2) {
                r = a_imageIn.getIntComponent0(x2, y2);
                int g = a_imageIn.getIntComponent1(x2, y2);
                b = a_imageIn.getIntComponent2(x2, y2);
                int corfinal = (int)((double)r * 0.3 + (double)b * 0.59 + (double)g * 0.11);
                a_imageOut.setIntColor(x2, y2, corfinal, corfinal, corfinal);
            }
            this.performanceMeter.stepsFinished(a_imageIn.getHeight());
            this.performanceMeter.incProgressBar(a_imageIn.getHeight());
        }
        this.performanceMeter.finishEvent();
        this.gx = new int[3][3];
        this.gy = new int[3][3];
        this.gx[0][0] = -1;
        this.gx[1][0] = 0;
        this.gx[2][0] = 1;
        this.gx[0][1] = -2;
        this.gx[1][1] = 0;
        this.gx[2][1] = 2;
        this.gx[0][2] = -1;
        this.gx[1][2] = 0;
        this.gx[2][2] = 1;
        this.gy[0][0] = 1;
        this.gy[1][0] = 2;
        this.gy[2][0] = 1;
        this.gy[0][1] = 0;
        this.gy[1][1] = 0;
        this.gy[2][1] = 0;
        this.gy[0][2] = -1;
        this.gy[1][2] = -2;
        this.gy[2][2] = -1;
        this.performanceMeter.startEvent("Border detector");
        for (x2 = 1; x2 < a_imageOut.getWidth() - 1; ++x2) {
            for (y2 = 1; y2 < a_imageOut.getHeight() - 1; ++y2) {
                r = a_imageIn.getIntComponent0(x2, y2);
                int g = a_imageIn.getIntComponent1(x2, y2);
                b = a_imageIn.getIntComponent2(x2, y2);
                this.mul8gx = a_imageIn.Multi8p(x2, y2, this.gx);
                this.mul8gy = a_imageIn.Multi8p(x2, y2, this.gy);
                this.rn = Math.abs(this.mul8gx[0]) + Math.abs(this.mul8gy[0]);
                this.gn = Math.abs(this.mul8gx[1]) + Math.abs(this.mul8gy[1]);
                this.bn = Math.abs(this.mul8gx[2]) + Math.abs(this.mul8gy[2]);
                this.rn = a_imageOut.boundRGB(this.rn);
                this.gn = a_imageOut.boundRGB(this.gn);
                this.bn = a_imageOut.boundRGB(this.bn);
                a_imageOut.setIntColor(x2, y2, this.rn, this.gn, this.bn);
            }
            this.performanceMeter.stepsFinished(a_imageOut.getHeight() - 2);
            this.performanceMeter.incProgressBar(a_imageOut.getHeight() - 2);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.startEvent("Binarization");
        int limiar = 150;
        for (x = 0; x < a_imageOut.getWidth(); ++x) {
            for (y = 0; y < a_imageOut.getHeight(); ++y) {
                if (a_imageOut.getIntComponent0(x, y) > limiar || a_imageOut.getIntComponent0(x, y) + 20 > limiar || a_imageOut.getIntComponent0(x, y) - 20 > limiar) {
                    if (a_imageOut.getIntComponent1(x, y) <= limiar && a_imageOut.getIntComponent1(x, y) + 20 <= limiar && a_imageOut.getIntComponent1(x, y) - 20 <= limiar || a_imageOut.getIntComponent2(x, y) <= limiar && a_imageOut.getIntComponent2(x, y) + 20 <= limiar && a_imageOut.getIntComponent2(x, y) - 20 <= limiar) continue;
                    a_imageOut.setIntColor(x, y, 255, 255, 255);
                    continue;
                }
                a_imageOut.setIntColor(x, y, 0, 0, 0);
            }
            this.performanceMeter.stepsFinished(a_imageOut.getHeight());
            this.performanceMeter.incProgressBar(a_imageOut.getHeight());
        }
        this.performanceMeter.finishEvent();
        this.numeroCantos = 0;
        this.cantos = new int[a_imageOut.getWidth()][a_imageOut.getHeight()];
        this.performanceMeter.startEvent("Harris/Plessey");
        for (x = 2; x < a_imageOut.getWidth() - 1; ++x) {
            for (y = 2; y < a_imageOut.getHeight() - 1; ++y) {
                this.Gx = a_imageOut.getIntComponent0(x - 1, y - 1) * 1 + a_imageOut.getIntComponent0(x - 1, y) * 0 + a_imageOut.getIntComponent0(x - 1, y + 1) * -1;
                this.Gx = a_imageOut.getIntComponent0(x, y - 1) * 1 + a_imageOut.getIntComponent0(x, y) * 0 + a_imageOut.getIntComponent0(x, y + 1) * -1;
                this.Gx = this.Gx + (double)(a_imageOut.getIntComponent0(x + 1, y - 1) * 1) + (double)(a_imageOut.getIntComponent0(x + 1, y) * 0) + (double)(a_imageOut.getIntComponent0(x + 1, y + 1) * -1);
                this.Gy = a_imageOut.getIntComponent0(x - 1, y - 1) * -1 + a_imageOut.getIntComponent0(x, y - 1) * 0 + a_imageOut.getIntComponent0(x + 1, y - 1) * 1;
                this.Gy = a_imageOut.getIntComponent0(x - 1, y) * -1 + a_imageOut.getIntComponent0(x, y) * 0 + a_imageOut.getIntComponent0(x + 1, y) * 1;
                this.Gy = this.Gy + (double)(a_imageOut.getIntComponent0(x - 1, y + 1) * -1) + (double)(a_imageOut.getIntComponent0(x, y + 1) * 0) + (double)(a_imageOut.getIntComponent0(x + 1, y + 1) * 1);
                this.A = a_imageOut.multi8p(x, y, Math.pow(this.Gx, 2.0));
                this.B = a_imageOut.multi8p(x, y, Math.pow(this.Gy, 2.0));
                this.C = a_imageOut.multi8p(x, y, this.Gx + this.Gy);
                this.det = this.A * this.B - Math.pow(this.C, 2.0);
                this.trace = this.A + this.B;
                this.E = this.det - this.k * Math.pow(this.trace, 2.0);
                if (this.E > this.th) {
                    this.cantos[x][y] = 1;
                    ++this.numeroCantos;
                    a_imageOut.setIntColor(x, y, 255, 0, 0);
                }
                this.Gx = 0.0;
                this.Gy = 0.0;
                this.A = 0.0;
                this.B = 0.0;
                this.C = 0.0;
                this.E = 0.0;
                this.det = 0.0;
                this.trace = 0.0;
            }
            this.performanceMeter.stepsFinished(a_imageIn.getHeight() - 3);
            this.performanceMeter.incProgressBar(a_imageIn.getHeight() - 3);
        }
        this.performanceMeter.finishEvent();
        int corners = 0;
        this.performanceMeter.startEvent("Segmentation");
        for (int x3 = 1; x3 < a_imageOut.getWidth() - 1; ++x3) {
            for (int y3 = 1; y3 < a_imageOut.getHeight() - 1; ++y3) {
                if (this.cantos[x3][y3] != 1 || x3 + 40 >= a_imageOut.getWidth() || y3 + 40 >= a_imageOut.getHeight()) continue;
                a_imageOut.setIntColor(x3, y3, 255, 0, 0);
                this.crop.setAttribute("x", (Object)x3);
                this.crop.setAttribute("y", (Object)y3);
                this.crop.setAttribute("width", (Object)40);
                this.crop.setAttribute("height", (Object)40);
                MarvinImage imgTmp = a_imageIn.clone();
                this.crop.process(a_imageIn, imgTmp);
                if (!a_previewMode) {
                    try {
                        if (this.modoAnalise) {
                            File tmp = new File("pattern/tmp/" + corners + ".jpg");
                            while (tmp.exists()) {
                                tmp = new File("pattern/" + this.path + "/" + ++corners + ".jpg");
                            }
                            ImageIO.write((RenderedImage)imgTmp.getBufferedImage(), "jpg", tmp);
                            imgTmp = null;
                            ++corners;
                        } else {
                            File dir = new File("pattern/" + this.path + "/");
                            dir.mkdirs();
                            File tmp = new File("pattern/" + this.path + "/" + corners + ".jpg");
                            while (tmp.exists()) {
                                tmp = new File("pattern/" + this.path + "/" + ++corners + ".jpg");
                            }
                            ImageIO.write((RenderedImage)imgTmp.getBufferedImage(), "jpg", tmp);
                            imgTmp = null;
                            ++corners;
                        }
                    }
                    catch (Exception dir) {
                        // empty catch block
                    }
                }
                for (int xN = x3 - 10; xN <= x3 + 40; ++xN) {
                    for (int yN = y3 - 10; yN <= y3 + 40; ++yN) {
                        try {
                            this.cantos[xN][yN] = 0;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.performanceMeter.stepsFinished(a_imageOut.getHeight() - 1);
            this.performanceMeter.incProgressBar(1);
        }
        this.performanceMeter.finishEvent();
        a_imageIn.setBufferedImage(a_imageOut.getBufferedImage());
        this.performanceMeter.finish();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isModoAnalise() {
        return this.modoAnalise;
    }

    public void setModoAnalise(boolean modoAnalise) {
        this.modoAnalise = modoAnalise;
    }
}

