/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.render.lindenmayer;

import java.awt.Polygon;
import java.util.Stack;
import marvin.image.MarvinImage;
import org.marvinproject.image.render.lindenmayer.Grammar;

public class TurtleGraphics {
    private double walkDistance;
    private double rotationAngle;
    private int startPx;
    private int startPy;
    private double startAngle;
    private double currentPx;
    private double currentPy;
    private double currentAngle;
    private Stack<Double[]> stateStack;
    private Polygon polygon = new Polygon();
    private boolean drawingPolygon = false;

    public TurtleGraphics() {
        this.stateStack = new Stack();
    }

    private void reset() {
        this.currentPx = 0.0;
        this.currentPy = 0.0;
        this.currentAngle = this.startAngle;
        this.stateStack.clear();
    }

    public void setStartPosition(int x, int y, double angle) {
        this.startPx = x;
        this.startPy = y;
        this.startAngle = angle;
    }

    public void setWalkDistance(double distance) {
        this.walkDistance = distance;
    }

    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
    }

    public void render(String text, Grammar grammar, int iterations, MarvinImage image) {
        this.reset();
        for (int i = 0; i < iterations; ++i) {
            text = grammar.derive(text);
        }
        this.setStartPosition(0, 0, this.startAngle);
        this.walkDistance = 1.0;
        this.walk(text, image, false);
        this.reset();
        this.walk(text, image, true);
    }

    private void walk(String text, MarvinImage image, boolean draw) {
        double deltaY;
        double deltaX;
        double minX = 9.99999999E8;
        double minY = 9.99999999E8;
        double maxX = -9.99999999E8;
        double maxY = -9.9999999E7;
        block11: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': {
                    double newPx = this.currentPx + Math.cos(Math.toRadians(this.currentAngle)) * this.walkDistance;
                    double newPy = this.currentPy - Math.sin(Math.toRadians(this.currentAngle)) * this.walkDistance;
                    if (!this.drawingPolygon) {
                        if (draw) {
                            this.drawLine((int)this.currentPx + this.startPx, (int)this.currentPy + this.startPy, (int)newPx + this.startPx, (int)newPy + this.startPy, image);
                        } else {
                            if (this.currentPx < minX) {
                                minX = this.currentPx;
                            }
                            if (this.currentPx > maxX) {
                                maxX = this.currentPx;
                            }
                            if (this.currentPy < minY) {
                                minY = this.currentPy;
                            }
                            if (this.currentPy > maxY) {
                                maxY = this.currentPy;
                            }
                        }
                    } else {
                        this.polygon.addPoint((int)newPx + this.startPx, (int)(newPy + (double)this.startPy));
                    }
                    this.currentPx = newPx;
                    this.currentPy = newPy;
                    continue block11;
                }
                case '+': 
                case 'g': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': {
                    this.currentAngle -= this.rotationAngle;
                    if (!(this.currentAngle < 0.0)) continue block11;
                    this.currentAngle = 360.0 + this.currentAngle;
                    continue block11;
                }
                case '-': {
                    this.currentAngle = (this.currentAngle + this.rotationAngle) % 360.0;
                    continue block11;
                }
                case '[': {
                    this.stateStack.push(new Double[]{this.currentPx, this.currentPy, this.currentAngle});
                    continue block11;
                }
                case ']': {
                    Double[] o = this.stateStack.pop();
                    this.currentPx = o[0];
                    this.currentPy = o[1];
                    this.currentAngle = o[2];
                    continue block11;
                }
                case '{': {
                    this.polygon = new Polygon();
                    this.drawingPolygon = true;
                    continue block11;
                }
                case '}': {
                    this.drawingPolygon = false;
                    continue block11;
                }
                case '#': {
                    if (text.charAt(i + 1) == '0' || text.charAt(i + 1) == '1' || text.charAt(i + 1) == '2' || text.charAt(i + 1) == '3' || text.charAt(i + 1) == '4') {
                        // empty if block
                    }
                    ++i;
                    continue block11;
                }
                case '&': {
                    ++i;
                }
            }
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (this.currentPx < minX) {
            minX = this.currentPx;
        }
        if (this.currentPx > maxX) {
            maxX = this.currentPx;
        }
        if (this.currentPy < minY) {
            minY = this.currentPy;
        }
        if (this.currentPy > maxY) {
            maxY = this.currentPy;
        }
        if ((deltaX = Math.abs(maxX - minX)) > (deltaY = Math.abs(maxY - minY))) {
            this.walkDistance = (double)width / deltaX;
            if (deltaY * this.walkDistance > (double)height) {
                this.walkDistance *= (double)height / (deltaY * this.walkDistance);
            }
        } else {
            this.walkDistance = (double)height / deltaY;
            if (deltaX * this.walkDistance > (double)width) {
                this.walkDistance *= (double)width / (deltaX * this.walkDistance);
            }
        }
        this.walkDistance *= 0.9;
        this.startPx = (int)((double)(width / 2) - (minX + deltaX / 2.0) * this.walkDistance);
        this.startPy = (int)((double)(height / 2) - (minY + deltaY / 2.0) * this.walkDistance);
    }

    private void drawLine(int x0, int y0, int x1, int y1, MarvinImage image) {
        int temp;
        boolean steep;
        boolean bl = steep = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        if (steep) {
            temp = x0;
            x0 = y0;
            y0 = temp;
            temp = x1;
            x1 = y1;
            y1 = temp;
        }
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        int deltax = x1 - x0;
        int deltay = Math.abs(y1 - y0);
        int error = deltax / 2;
        int y = y0;
        int ystep = y0 < y1 ? 1 : -1;
        for (int x = x0; x <= x1; ++x) {
            if (steep) {
                if (y >= 0 && y < image.getWidth() && x >= 0 && x < image.getHeight()) {
                    image.setIntColor(y, x, 0, 0, 0);
                }
            } else if (x >= 0 && x < image.getWidth() && y >= 0 && y < image.getHeight()) {
                image.setIntColor(x, y, 0, 0, 0);
            }
            if ((error -= deltay) >= 0) continue;
            y += ystep;
            error += deltax;
        }
    }
}

