/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.statistical.mode;

import java.util.HashMap;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Mode
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    MarvinAttributes attributes;
    MarvinPerformanceMeter performanceMeter;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("size", (Object)3);
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        this.performanceMeter.start("Moda Filter");
        int l_size = (Integer)this.attributes.get("size");
        int mapSize = l_size * l_size;
        int l_totalRed = 0;
        int l_totalGreen = 0;
        int l_totalBlue = 0;
        boolean qtd = false;
        int tmpx = 0;
        int tmpy = 0;
        int width = a_imageIn.getWidth();
        int height = a_imageIn.getHeight();
        this.performanceMeter.enableProgressBar("Moda Filter", a_imageIn.getWidth() * a_imageIn.getHeight());
        this.performanceMeter.startEvent("Moda Filter");
        boolean[][] l_arrMask = a_mask.getMask();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                tmpx = x - l_size;
                tmpy = y - l_size;
                HashMap<Integer, Integer> mapModaR = new HashMap<Integer, Integer>(mapSize);
                HashMap<Integer, Integer> mapModaG = new HashMap<Integer, Integer>(mapSize);
                HashMap<Integer, Integer> mapModaB = new HashMap<Integer, Integer>(mapSize);
                if (tmpx < 0) {
                    tmpx = 0;
                }
                if (tmpy < 0) {
                    tmpy = 0;
                }
                int finalX = x + l_size;
                int finalY = y + l_size;
                if (finalX > width) {
                    finalX = width;
                }
                if (finalY > height) {
                    finalY = height;
                }
                for (int xm = tmpx; xm < finalX; ++xm) {
                    for (int ym = tmpy; ym < y + l_size; ++ym) {
                        if (xm < 0 || xm >= width || ym < 0 || ym >= height) continue;
                        int rgb = a_imageIn.getIntColor(xm, ym);
                        l_totalRed = (rgb & 0xFF0000) >>> 16;
                        l_totalGreen = (rgb & 0xFF00) >>> 8;
                        l_totalBlue = rgb & 0xFF;
                        Integer l_val = (Integer)mapModaR.get(l_totalRed);
                        if (l_val == null) {
                            l_val = 0;
                        }
                        l_val = l_val + 1;
                        mapModaR.put(l_totalRed, l_val);
                        l_val = (Integer)mapModaG.get(l_totalGreen);
                        if (l_val == null) {
                            l_val = 0;
                        }
                        l_val = l_val + 1;
                        mapModaG.put(l_totalGreen, l_val);
                        l_val = (Integer)mapModaB.get(l_totalBlue);
                        if (l_val == null) {
                            l_val = 0;
                        }
                        l_val = l_val + 1;
                        mapModaB.put(l_totalBlue, l_val);
                    }
                }
                Integer r1 = 0;
                for (Integer it : mapModaR.keySet()) {
                    if ((Integer)mapModaR.get(it) < r1) continue;
                    r1 = it;
                }
                Integer g1 = 0;
                for (Integer it : mapModaG.keySet()) {
                    if ((Integer)mapModaG.get(it) < g1) continue;
                    g1 = it;
                }
                Integer b1 = 0;
                for (Integer it : mapModaB.keySet()) {
                    if ((Integer)mapModaB.get(it) < b1) continue;
                    b1 = it;
                }
                a_imageOut.setIntColor(x, y, a_imageIn.getAlphaComponent(x, y), r1.intValue(), g1.intValue(), b1.intValue());
            }
            this.performanceMeter.incProgressBar(height);
            this.performanceMeter.stepsFinished(height);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.finish();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblWidth", "Size:");
            this.attributesPanel.addTextField("txtSize", "size", this.attributes);
            this.attributesPanel.newComponentRow();
        }
        return this.attributesPanel;
    }
}

