/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.test.plugin;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinAttributesPanel;
import marvin.gui.MarvinPluginWindow;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Plugin
extends MarvinAbstractImagePlugin
implements ChangeListener,
KeyListener {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private MarvinPluginWindow tela;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("hsR", (Object)0);
        this.attributes.set("hsG", (Object)0);
        this.attributes.set("hsB", (Object)0);
        this.attributes.set("txtR", (Object)"0");
        this.attributes.set("txtG", (Object)"0");
        this.attributes.set("txtB", (Object)"0");
    }

    public int truncate(int a) {
        if (a < 0) {
            return 0;
        }
        if (a > 255) {
            return 255;
        }
        return a;
    }

    public int positive(int a) {
        if (a < 0) {
            return -a;
        }
        return a;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        RGB rgbImagem = new RGB();
        int l_red = (Integer)this.attributes.get("hsR");
        int l_green = (Integer)this.attributes.get("hsG");
        int l_blue = (Integer)this.attributes.get("hsB");
        int width = a_imageIn.getWidth();
        int height = a_imageIn.getHeight();
        boolean[][] l_arrMask = a_mask.getMask();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                rgbImagem.setR(a_imageIn.getIntComponent0(x, y));
                rgbImagem.setG(a_imageIn.getIntComponent1(x, y));
                rgbImagem.setB(a_imageIn.getIntComponent2(x, y));
                rgbImagem.setR((int)((double)rgbImagem.getR() * (255.0 / (255.0 - (double)l_red))));
                rgbImagem.setG((int)((double)rgbImagem.getG() * (255.0 / (255.0 - (double)l_green))));
                rgbImagem.setB((int)((double)rgbImagem.getB() * (255.0 / (255.0 - (double)l_blue))));
                a_imageOut.setIntColor(x, y, rgbImagem.getR(), rgbImagem.getG(), rgbImagem.getB());
            }
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblC", "Cyan");
            this.attributesPanel.addHorizontalSlider("hsR", "hsR", -100, 100, 0, this.attributes);
            this.attributesPanel.addLabel("lblR", "Red");
            this.attributesPanel.addTextField("txtR", "txtR", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblM", "Magenta");
            this.attributesPanel.addHorizontalSlider("hsG", "hsG", -100, 100, 0, this.attributes);
            this.attributesPanel.addLabel("lblG", "Green");
            this.attributesPanel.addTextField("txtG", "txtG", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblY", "Yellow");
            this.attributesPanel.addHorizontalSlider("hsB", "hsB", -100, 100, 0, this.attributes);
            this.attributesPanel.addLabel("lblB", "Blue");
            this.attributesPanel.addTextField("txtB", "txtB", this.attributes);
            this.attributesPanel.newComponentRow();
            JSlider sliderR = (JSlider)this.attributesPanel.getComponent("hsR").getComponent();
            JSlider sliderG = (JSlider)this.attributesPanel.getComponent("hsG").getComponent();
            JSlider sliderB = (JSlider)this.attributesPanel.getComponent("hsB").getComponent();
            JTextField txtR = (JTextField)this.attributesPanel.getComponent("txtR").getComponent();
            JTextField txtG = (JTextField)this.attributesPanel.getComponent("txtG").getComponent();
            JTextField txtB = (JTextField)this.attributesPanel.getComponent("txtB").getComponent();
            sliderR.addChangeListener(this);
            sliderG.addChangeListener(this);
            sliderB.addChangeListener(this);
            txtR.addKeyListener(this);
            txtG.addKeyListener(this);
            txtB.addKeyListener(this);
        }
        return this.attributesPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider barra1 = (JSlider)this.attributesPanel.getComponent("hsR").getComponent();
        JSlider barra2 = (JSlider)this.attributesPanel.getComponent("hsG").getComponent();
        JSlider barra3 = (JSlider)this.attributesPanel.getComponent("hsB").getComponent();
        JSlider barra = (JSlider)e.getSource();
        JTextField lbl = null;
        if (e.getSource() == barra1) {
            lbl = (JTextField)this.attributesPanel.getComponent("txtR").getComponent();
        } else if (e.getSource() == barra2) {
            lbl = (JTextField)this.attributesPanel.getComponent("txtG").getComponent();
        } else {
            if (e.getSource() == barra3) {
                // empty if block
            }
            lbl = (JTextField)this.attributesPanel.getComponent("txtB").getComponent();
        }
        lbl.setText("" + barra.getValue());
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        block9: {
            JTextField txtR = (JTextField)this.attributesPanel.getComponent("txtR").getComponent();
            JTextField txtG = (JTextField)this.attributesPanel.getComponent("txtG").getComponent();
            JTextField txtB = (JTextField)this.attributesPanel.getComponent("txtB").getComponent();
            JSlider barra1 = (JSlider)this.attributesPanel.getComponent("hsR").getComponent();
            JSlider barra2 = (JSlider)this.attributesPanel.getComponent("hsG").getComponent();
            JSlider barra3 = (JSlider)this.attributesPanel.getComponent("hsB").getComponent();
            try {
                if (e.getSource() == txtR) {
                    barra1.setValue(Integer.parseInt(txtR.getText().toString()));
                } else if (e.getSource() == txtG) {
                    barra2.setValue(Integer.parseInt(txtG.getText().toString()));
                } else if (e.getSource() == txtB) {
                    barra3.setValue(Integer.parseInt(txtB.getText().toString()));
                }
            }
            catch (Exception exception) {
                if (e.getSource() == txtR) {
                    barra1.setValue(0);
                    txtR.setText("0");
                }
                if (e.getSource() == txtG) {
                    barra2.setValue(0);
                    txtG.setText("0");
                }
                if (e.getSource() != txtB) break block9;
                barra3.setValue(0);
                txtB.setText("0");
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class RGB {
        private int r;
        private int g;
        private int b;

        public RGB() {
            this.r = 0;
            this.g = 0;
            this.b = 0;
        }

        public RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getR() {
            return this.r;
        }

        public void setR(int r) {
            this.r = Plugin.this.truncate(r);
        }

        public int getG() {
            return this.g;
        }

        public void setG(int g) {
            this.g = Plugin.this.truncate(g);
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = Plugin.this.truncate(b);
        }
    }
}

