/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.transform.rotate;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Rotate
extends MarvinAbstractImagePlugin {
    private static final String CLOCKWISE90 = "clockwise90";
    private static final String ACLOCKWISE90 = "anticlockwise90";
    private static final String OTHER = "Other";
    private int MaximumRotationAngle = 89;
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("rotate", (Object)"angle");
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("labelRotate", "Options:");
            this.attributesPanel.addComboBox("combpRotate", "rotate", new Object[]{CLOCKWISE90, ACLOCKWISE90, OTHER}, this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblRotateAngle", "Angle of Rotation");
            this.attributesPanel.addHorizontalSlider("sliderRotateAngle", "RotateAngle", -this.MaximumRotationAngle, this.MaximumRotationAngle, 0, this.attributes);
            this.attributesPanel.newComponentRow();
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int l_aImageHeight = a_imageIn.getHeight();
        int l_aImageWidth = a_imageIn.getWidth();
        double l_rotateAngleRadians = 0.0;
        String userOption = (String)this.attributes.get("rotate");
        this.attributes.set("rotateTextField", (Object)userOption);
        if (userOption.intern() == CLOCKWISE90.intern()) {
            System.out.println("90clockwise");
            int l_newHeight = l_aImageWidth;
            int l_newWidth = l_aImageHeight;
            a_imageOut.setDimension(l_newWidth, l_newHeight);
            for (int xx = 0; xx < l_aImageWidth; ++xx) {
                for (int yy = l_aImageHeight - 1; yy >= 0; --yy) {
                    a_imageOut.setIntColor(l_aImageHeight - 1 - yy, xx, a_imageIn.getIntColor(xx, yy));
                }
            }
        } else if (userOption.intern() == ACLOCKWISE90.intern()) {
            System.out.println("90clockwise");
            int l_newHeight = l_aImageWidth;
            int l_newWidth = l_aImageHeight;
            a_imageOut.setDimension(l_newWidth, l_newHeight);
            for (int xx = l_aImageWidth - 1; xx > 0; --xx) {
                for (int yy = 0; yy < l_aImageHeight; ++yy) {
                    a_imageOut.setIntColor(yy, l_aImageWidth - 1 - xx, a_imageIn.getIntColor(xx, yy));
                }
            }
        } else {
            int l_rotateAngle = (Integer)this.attributes.get("RotateAngle");
            l_rotateAngleRadians = Math.toRadians(l_rotateAngle);
            this.rotateImage(a_imageIn, a_imageOut, l_rotateAngleRadians);
        }
    }

    private void interpolateImage(MarvinImage a_image, MarvinImage a_originalImage, int[][][] a_LookUpArray, double a_rotateAngle, int a_initialisationValue) {
        int l_rotatedImageWidth = a_image.getWidth();
        int l_rotatedImageHeight = a_image.getHeight();
        for (int xx = 1; xx < l_rotatedImageWidth - 1; ++xx) {
            for (int yy = 1; yy < l_rotatedImageHeight - 1; ++yy) {
                if (a_LookUpArray[xx][yy][0] != a_initialisationValue) continue;
                int l_leftValue = a_LookUpArray[xx - 1][yy][2];
                int l_rightValue = a_LookUpArray[xx - 1][yy][2];
                int l_difference = l_rightValue - l_leftValue;
                a_image.setIntColor(xx, yy, l_leftValue + (l_difference + 2));
            }
        }
    }

    public void initialiseLookUpArray(int[][][] a_LookUpArray, int[] dimensions, int a_InitialisationValue) {
        for (int xx = 0; xx < dimensions[0]; ++xx) {
            for (int yy = 0; yy < dimensions[1]; ++yy) {
                a_LookUpArray[xx][yy][0] = a_InitialisationValue;
                a_LookUpArray[xx][yy][1] = 0;
                a_LookUpArray[xx][yy][2] = 0;
            }
        }
    }

    private void rotateImage(MarvinImage a_imageIn, MarvinImage a_imageOut, double a_rotateAngleRads) {
        int l_aimageHeight = a_imageIn.getHeight();
        int l_aimageWidth = a_imageIn.getWidth();
        double l_absRotateAngle = Math.abs(a_rotateAngleRads);
        int l_newHeight = (int)Math.ceil((double)l_aimageWidth * Math.sin(l_absRotateAngle) + Math.ceil((double)l_aimageHeight * Math.cos(l_absRotateAngle)));
        int l_newWidth = (int)Math.ceil((double)l_aimageHeight * Math.sin(l_absRotateAngle) + Math.ceil((double)l_aimageWidth * Math.cos(l_absRotateAngle)));
        int[][][] l_LookUpArray = new int[l_newWidth][l_newHeight][3];
        int l_initialisationValue = 654321;
        int[] l_dimensions = new int[]{l_newWidth, l_newHeight, 3};
        this.initialiseLookUpArray(l_LookUpArray, l_dimensions, l_initialisationValue);
        a_imageOut.setDimension(Math.abs(l_newWidth), Math.abs(l_newHeight));
        for (int xx = 0; xx < l_aimageWidth - 0; ++xx) {
            for (int yy = 0; yy < l_aimageHeight - 0; ++yy) {
                int l_newXCoordinate = (int)(Math.cos(a_rotateAngleRads) * (double)(xx - l_aimageWidth / 2) - Math.sin(a_rotateAngleRads) * (double)(yy - l_aimageHeight / 2) + (double)(l_newWidth / 2));
                int l_newYCoordinate = (int)(Math.sin(a_rotateAngleRads) * (double)(xx - l_aimageWidth / 2) + Math.cos(a_rotateAngleRads) * (double)(yy - l_aimageHeight / 2) + (double)(l_newHeight / 2));
                try {
                    a_imageOut.setIntColor(l_newXCoordinate, l_newYCoordinate, a_imageIn.getIntColor(xx, yy));
                    l_LookUpArray[l_newXCoordinate][l_newYCoordinate][0] = xx;
                    l_LookUpArray[l_newXCoordinate][l_newYCoordinate][1] = yy;
                    l_LookUpArray[l_newXCoordinate][l_newYCoordinate][2] = a_imageIn.getIntColor(xx, yy);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(l_newXCoordinate + " " + l_newYCoordinate);
                }
            }
        }
        this.interpolateImage(a_imageOut, a_imageIn, l_LookUpArray, a_rotateAngleRads, l_initialisationValue);
    }
}

