/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.transform.skew;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Skew
extends MarvinAbstractImagePlugin {
    private static final String HORIZONTAL = "Horizontal";
    private static final String VERTICAL = "Vertical";
    private int SELECTEDANGLE = 0;
    private MarvinAttributesPanel attributesPanel;
    MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("skew", (Object)"horizontal");
        this.attributes.set("selected", (Object)String.valueOf(this.SELECTEDANGLE));
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("labelSkew", "Skew:");
            this.attributesPanel.addComboBox("combpSkew", "skew", new Object[]{HORIZONTAL, VERTICAL}, this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblSkewAngle", "SkewAngle");
            this.attributesPanel.addHorizontalSlider("sliderSkewAngle", "SkewAngle", -89, 89, 0, this.attributes);
            this.attributesPanel.newComponentRow();
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        String l_operation = (String)this.attributes.get("skew");
        int s_angle = (Integer)this.attributes.get("SkewAngle");
        double s_angle_rad = Math.toRadians(s_angle);
        if (l_operation.equals(HORIZONTAL)) {
            this.skewHorizontal(a_imageIn, a_imageOut, s_angle_rad);
        } else {
            this.skewVertical(a_imageIn, a_imageOut, s_angle_rad);
        }
    }

    private void skewHorizontal(MarvinImage a_imageIn, MarvinImage a_imageOut, double a_skewAngleRad) {
        int y;
        int x;
        int l_aHeight = a_imageIn.getHeight();
        int l_aWidth = a_imageIn.getWidth();
        int l_extraWidth = (int)Math.ceil((double)l_aHeight * Math.tan(a_skewAngleRad));
        int l_newWidth = l_aWidth + Math.abs(l_extraWidth);
        for (int xx = 0; xx < l_aWidth; ++xx) {
            for (int yy = 0; yy < l_aHeight; ++yy) {
                a_imageOut.setIntColor(xx, yy, a_imageIn.getAlphaComponent(xx, yy), 0);
            }
        }
        a_imageOut.resize(l_newWidth, l_aHeight);
        if (l_extraWidth > 0) {
            for (x = 0; x < l_aWidth; ++x) {
                for (y = 0; y < l_aHeight; ++y) {
                    int l_newXcoordinate = x + (int)Math.abs((double)(y - l_aHeight) * Math.tan(a_skewAngleRad));
                    int r = a_imageIn.getIntComponent0(x, y);
                    int g = a_imageIn.getIntComponent1(x, y);
                    int b = a_imageIn.getIntComponent2(x, y);
                    a_imageOut.setIntColor(l_newXcoordinate, y, a_imageIn.getAlphaComponent(l_newXcoordinate, y), r, g, b);
                }
            }
        } else {
            for (x = 0; x < l_aWidth; ++x) {
                for (y = l_aHeight - 1; y >= 0; --y) {
                    int new_xcoordinate = x + (int)Math.abs((double)y * Math.tan(a_skewAngleRad));
                    int r = a_imageIn.getIntComponent0(x, y);
                    int g = a_imageIn.getIntComponent1(x, y);
                    int b = a_imageIn.getIntComponent2(x, y);
                    a_imageOut.setIntColor(new_xcoordinate, y, a_imageIn.getAlphaComponent(new_xcoordinate, y), r, g, b);
                }
            }
        }
    }

    private void skewVertical(MarvinImage a_imageIn, MarvinImage a_imageOut, double a_skewAngleRad) {
        int l_aWidth = a_imageIn.getWidth();
        int l_aHeight = a_imageIn.getHeight();
        int l_extraHeight = (int)Math.ceil((double)l_aWidth * Math.tan(a_skewAngleRad));
        int l_newHeight = l_aHeight + Math.abs(l_extraHeight);
        for (int xx = 0; xx < l_aWidth; ++xx) {
            for (int yy = 0; yy < l_aHeight; ++yy) {
                a_imageOut.setIntColor(xx, yy, a_imageIn.getAlphaComponent(xx, yy), 0);
            }
        }
        a_imageOut.resize(l_aWidth, l_newHeight);
        for (int x = 0; x < l_aWidth; ++x) {
            for (int y = 0; y < l_aHeight; ++y) {
                int l_newYcoordinate = l_extraHeight > 0 ? y + (int)((double)x * Math.tan(a_skewAngleRad)) : l_newHeight - l_aHeight + y - (int)Math.abs((double)x * Math.tan(a_skewAngleRad));
                int r = a_imageIn.getIntComponent0(x, y);
                int g = a_imageIn.getIntComponent1(x, y);
                int b = a_imageIn.getIntComponent2(x, y);
                a_imageOut.setIntColor(x, l_newYcoordinate, a_imageIn.getAlphaComponent(x, l_newYcoordinate), r, g, b);
            }
        }
    }
}

