/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.transform.watershed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;
import org.marvinproject.image.transform.watershed.WatershedPixel;

public class Watershed
extends MarvinAbstractImagePlugin {
    private MarvinImagePlugin gray;
    private List<List<WatershedPixel>> HeightMap;
    private WatershedPixel[][] Image;
    private int width;
    private int height;
    private List<WatershedPixel> query;
    private WatershedPixel dummyPixel;

    public void load() {
        this.gray = new GrayScale();
        this.gray.load();
        this.HeightMap = new ArrayList<List<WatershedPixel>>(256);
        for (int i = 0; i < 256; ++i) {
            this.HeightMap.add(new ArrayList());
        }
        this.query = new LinkedList<WatershedPixel>();
        this.dummyPixel = new WatershedPixel(0, 0);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        int i;
        int CurrentLabel = 0;
        MarvinImage tempImage = new MarvinImage(imageIn.getWidth(), imageIn.getHeight());
        this.gray.process(imageIn, tempImage);
        this.width = tempImage.getWidth();
        this.height = tempImage.getHeight();
        this.Image = new WatershedPixel[this.width][this.height];
        int[][] labels = new int[this.width][this.height];
        for (i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                WatershedPixel pixel;
                this.Image[i][j] = pixel = new WatershedPixel(i, j);
                this.HeightMap.get(tempImage.getIntComponent0(i, j)).add(pixel);
            }
        }
        for (int h = 0; h < this.HeightMap.size(); ++h) {
            block3: for (WatershedPixel wpixel : this.HeightMap.get(h)) {
                wpixel.setLabel(-2);
                List<WatershedPixel> neighbourPixels = this.Neighbours(wpixel);
                Iterator<WatershedPixel> iterator = neighbourPixels.iterator();
                while (iterator.hasNext()) {
                    WatershedPixel neighbourPixel = iterator.next();
                    if (neighbourPixel.getLabel() < 0) continue;
                    wpixel.setDistance(1);
                    this.query.add(wpixel);
                    continue block3;
                }
            }
            this.query.add(this.dummyPixel);
            int CurrentDistance = 1;
            while (!this.query.isEmpty()) {
                Object nextProccessPixel = this.query.remove(0);
                if (this.query.isEmpty()) break;
                if (nextProccessPixel.equals(this.dummyPixel)) {
                    ++CurrentDistance;
                    this.query.add(this.dummyPixel);
                    nextProccessPixel = this.query.remove(0);
                }
                List<WatershedPixel> neighbourPixels = this.Neighbours((WatershedPixel)nextProccessPixel);
                for (WatershedPixel neighbourPixel : neighbourPixels) {
                    if (neighbourPixel.getDistance() <= CurrentDistance && neighbourPixel.getLabel() >= 0) {
                        if (neighbourPixel.getLabel() > 0) {
                            if (((WatershedPixel)nextProccessPixel).getLabel() == -2) {
                                ((WatershedPixel)nextProccessPixel).setLabel(neighbourPixel.getLabel());
                                continue;
                            }
                            if (((WatershedPixel)nextProccessPixel).getLabel() == neighbourPixel.getLabel()) continue;
                            ((WatershedPixel)nextProccessPixel).setLabel(0);
                            continue;
                        }
                        if (((WatershedPixel)nextProccessPixel).getLabel() != -2) continue;
                        ((WatershedPixel)nextProccessPixel).setLabel(0);
                        continue;
                    }
                    if (neighbourPixel.getDistance() != 0 || neighbourPixel.getLabel() != -2) continue;
                    neighbourPixel.setDistance(CurrentDistance + 1);
                    this.query.add(neighbourPixel);
                }
            }
            for (WatershedPixel wpixel : this.HeightMap.get(h)) {
                wpixel.setDistance(0);
                if (wpixel.getLabel() != -2) continue;
                wpixel.setLabel(++CurrentLabel);
                this.query.add(wpixel);
                while (!this.query.isEmpty()) {
                    WatershedPixel nextPixel = this.query.remove(0);
                    List<WatershedPixel> neighbourPixels = this.Neighbours(nextPixel);
                    for (WatershedPixel neighbourPixel : neighbourPixels) {
                        if (neighbourPixel.getLabel() != -2) continue;
                        neighbourPixel.setLabel(CurrentLabel);
                        this.query.add(neighbourPixel);
                    }
                }
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                labels[i][j] = this.Image[i][j].getLabel();
            }
        }
        if (attrOut != null) {
            attrOut.set("imageLabels", (Object)labels);
        }
    }

    private List<WatershedPixel> Neighbours(WatershedPixel p) {
        int x = p.getX();
        int y = p.getY();
        ArrayList<WatershedPixel> NPixels = new ArrayList<WatershedPixel>(4);
        if (x > 0) {
            NPixels.add(this.Image[x - 1][y]);
        }
        if (x < this.width - 1) {
            NPixels.add(this.Image[x + 1][y]);
        }
        if (y > 0) {
            NPixels.add(this.Image[x][y - 1]);
        }
        if (y < this.height - 1) {
            NPixels.add(this.Image[x][y + 1]);
        }
        return NPixels;
    }
}

