/*
 * Decompiled with CFR 0.152.
 */
package image.filters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.io.MarvinImageIO;
import marvinplugins.MarvinPluginCollection;

public class Filters
extends JFrame {
    private static final long serialVersionUID = 638146160345280359L;
    private MarvinImagePanel imagePanel;
    private MarvinImage image;
    private MarvinImage backupImage;
    private JPanel panelBottom;
    private JButton buttonGray;
    private JButton buttonSepia;
    private JButton buttonInvert;
    private JButton buttonReset;

    public Filters() {
        super("Filters Sample");
        ButtonHandler buttonHandler = new ButtonHandler();
        this.buttonGray = new JButton("Gray");
        this.buttonGray.addActionListener(buttonHandler);
        this.buttonSepia = new JButton("Sepia");
        this.buttonSepia.addActionListener(buttonHandler);
        this.buttonInvert = new JButton("Invert");
        this.buttonInvert.addActionListener(buttonHandler);
        this.buttonReset = new JButton("Reset");
        this.buttonReset.addActionListener(buttonHandler);
        this.panelBottom = new JPanel();
        this.panelBottom.add(this.buttonGray);
        this.panelBottom.add(this.buttonSepia);
        this.panelBottom.add(this.buttonInvert);
        this.panelBottom.add(this.buttonReset);
        this.imagePanel = new MarvinImagePanel();
        Container l_c = this.getContentPane();
        l_c.setLayout(new BorderLayout());
        l_c.add((Component)this.imagePanel, "North");
        l_c.add((Component)this.panelBottom, "South");
        this.loadImage();
        this.imagePanel.setImage(this.image);
        this.setSize(320, 600);
        this.setVisible(true);
    }

    private void loadImage() {
        this.image = MarvinImageIO.loadImage((String)"src/main/resources/arara.jpg");
        this.backupImage = this.image.clone();
    }

    public static void main(String[] args) {
        Filters t = new Filters();
        t.setDefaultCloseOperation(3);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent a_event) {
            Filters.this.image = Filters.this.backupImage.clone();
            if (a_event.getSource() == Filters.this.buttonGray) {
                MarvinPluginCollection.grayScale((MarvinImage)Filters.this.image);
            } else if (a_event.getSource() == Filters.this.buttonSepia) {
                MarvinPluginCollection.sepia((MarvinImage)Filters.this.image, (int)50);
            } else if (a_event.getSource() == Filters.this.buttonInvert) {
                MarvinPluginCollection.invertColors((MarvinImage)Filters.this.image);
            }
            Filters.this.image.update();
            Filters.this.imagePanel.setImage(Filters.this.image);
        }
    }
}

