/*
 * Decompiled with CFR 0.152.
 */
package image.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.io.MarvinImageIO;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinPluginHistory;
import org.marvinproject.image.color.brightnessAndContrast.BrightnessAndContrast;
import org.marvinproject.image.color.invert.Invert;
import org.marvinproject.image.edge.edgeDetector.EdgeDetector;

public class History
extends JFrame {
    private static final long serialVersionUID = -1969606652291318686L;
    JButton buttonShowHistory;
    JButton buttonApply;
    MarvinPluginHistory history;
    MarvinImagePlugin tempPlugin;
    MarvinImage originalImage;
    MarvinImage resultImage;
    MarvinImagePanel imagePanelOriginal;
    MarvinImagePanel imagePanelNew;

    public History() {
        super("Plug-in History Sample");
        ButtonHandler buttonHandler = new ButtonHandler();
        this.buttonShowHistory = new JButton("Show History");
        this.buttonShowHistory.addActionListener(buttonHandler);
        this.buttonApply = new JButton("Apply");
        this.buttonApply.addActionListener(buttonHandler);
        JPanel l_panelBottom = new JPanel();
        l_panelBottom.add(this.buttonApply);
        l_panelBottom.add(this.buttonShowHistory);
        this.imagePanelOriginal = new MarvinImagePanel();
        this.imagePanelNew = new MarvinImagePanel();
        JPanel l_panelTop = new JPanel();
        l_panelTop.add((Component)this.imagePanelOriginal);
        l_panelTop.add((Component)this.imagePanelNew);
        Container l_c = this.getContentPane();
        l_c.setLayout(new BorderLayout());
        l_c.add((Component)l_panelTop, "North");
        l_c.add((Component)l_panelBottom, "South");
        this.originalImage = MarvinImageIO.loadImage((String)"src/main/resources/tucano.jpg");
        this.imagePanelOriginal.setImage(this.originalImage);
        this.imagePanelNew.setPreferredSize(this.imagePanelOriginal.getPreferredSize());
        this.setSize(765, 630);
        this.setVisible(true);
    }

    private void process() {
        this.history = new MarvinPluginHistory();
        this.resultImage = this.originalImage.clone();
        MarvinImage l_tempImage = new MarvinImage(this.resultImage.getWidth(), this.resultImage.getHeight());
        this.history.addEntry("Original", this.resultImage, null);
        this.tempPlugin = new EdgeDetector();
        this.tempPlugin.load();
        this.tempPlugin.process(this.resultImage, l_tempImage);
        l_tempImage.update();
        this.resultImage = l_tempImage.clone();
        this.history.addEntry("Edge", this.resultImage, this.tempPlugin.getAttributes());
        this.tempPlugin = new BrightnessAndContrast();
        this.tempPlugin.load();
        this.tempPlugin.setAttribute("brightness", (Object)-127);
        this.tempPlugin.setAttribute("contrast", (Object)127);
        this.tempPlugin.process(this.resultImage, this.resultImage);
        this.resultImage.update();
        this.history.addEntry("BrightenessContrast", this.resultImage, this.tempPlugin.getAttributes());
        this.tempPlugin = new Invert();
        this.tempPlugin.load();
        this.tempPlugin.process(this.resultImage, this.resultImage);
        this.resultImage.update();
        this.history.addEntry("Invert", this.resultImage, this.tempPlugin.getAttributes());
        this.imagePanelNew.setImage(this.resultImage);
    }

    public static void main(String[] args) {
        History s = new History();
        s.setDefaultCloseOperation(3);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == History.this.buttonApply) {
                History.this.process();
            } else if (e.getSource() == History.this.buttonShowHistory && History.this.history != null) {
                History.this.history.showThumbnailHistory();
            }
        }
    }
}

