/*
 * Decompiled with CFR 0.152.
 */
package image.multithread;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.io.MarvinImageIO;
import marvin.plugin.MarvinImagePlugin;
import marvin.thread.MarvinThread;
import marvin.thread.MarvinThreadEvent;
import marvin.thread.MarvinThreadListener;
import org.marvinproject.image.statistical.maximum.Maximum;

public class Multithread
extends JFrame
implements MarvinThreadListener {
    private static final long serialVersionUID = 6748766294528594620L;
    private JButton buttonSingleThread;
    private JButton buttonMultiThread;
    private JButton buttonResetImage;
    private JLabel labelPerformance;
    private MarvinImagePanel imagePanel;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage originalImage;
    private int threadsFinished;
    private long processStartTime;

    public Multithread() {
        super("Multithread Sample");
        ButtonHandler buttonHandler = new ButtonHandler();
        this.buttonSingleThread = new JButton("Single Thread");
        this.buttonMultiThread = new JButton("Multi Thread");
        this.buttonResetImage = new JButton("Reset Image");
        this.buttonSingleThread.addActionListener(buttonHandler);
        this.buttonMultiThread.addActionListener(buttonHandler);
        this.buttonResetImage.addActionListener(buttonHandler);
        this.labelPerformance = new JLabel("Performance:");
        JPanel l_panelIntern = new JPanel();
        l_panelIntern.add(this.buttonSingleThread);
        l_panelIntern.add(this.buttonMultiThread);
        l_panelIntern.add(this.buttonResetImage);
        JPanel l_panelBottom = new JPanel();
        l_panelBottom.setLayout(new BorderLayout());
        l_panelBottom.add((Component)l_panelIntern, "North");
        l_panelBottom.add((Component)this.labelPerformance, "South");
        this.imagePanel = new MarvinImagePanel();
        Container l_container = this.getContentPane();
        l_container.setLayout(new BorderLayout());
        l_container.add((Component)this.imagePanel, "North");
        l_container.add((Component)l_panelBottom, "South");
        this.loadImages();
        this.setSize(this.originalImage.getWidth() + 20, 690);
        this.setVisible(true);
    }

    private void loadImages() {
        this.originalImage = MarvinImageIO.loadImage((String)"src/main/resources/senna.jpg");
        this.imageIn = new MarvinImage(this.originalImage.getWidth(), this.originalImage.getHeight());
        this.imageOut = new MarvinImage(this.originalImage.getWidth(), this.originalImage.getHeight());
        this.imagePanel.setImage(this.originalImage);
    }

    public void threadFinished(MarvinThreadEvent e) {
        ++this.threadsFinished;
        if (this.threadsFinished == 2) {
            this.imageOut.update();
            this.imagePanel.setImage(this.imageOut);
            this.labelPerformance.setText("Performance: " + (System.currentTimeMillis() - this.processStartTime) + " milliseconds (Multi Thread)");
            this.repaint();
        }
    }

    public static void main(String[] args) {
        Multithread t = new Multithread();
        t.setDefaultCloseOperation(3);
    }

    private void singleThread() {
        this.processStartTime = System.currentTimeMillis();
        Maximum l_pluginImage = new Maximum();
        l_pluginImage.load();
        l_pluginImage.process(this.imageIn, this.imageOut);
        this.imageOut.update();
        this.imagePanel.setImage(this.imageOut);
        this.labelPerformance.setText("Performance: " + (System.currentTimeMillis() - this.processStartTime) + " milliseconds (Single Thread)");
        this.repaint();
    }

    private void multiThread() {
        this.processStartTime = System.currentTimeMillis();
        Maximum l_pluginImage_1 = new Maximum();
        Maximum l_pluginImage_2 = new Maximum();
        l_pluginImage_1.load();
        l_pluginImage_2.load();
        MarvinImageMask l_mask1 = new MarvinImageMask(this.imageIn.getWidth(), this.imageIn.getHeight(), 0, 0, this.imageIn.getWidth(), this.imageIn.getHeight() / 2);
        MarvinImageMask l_mask2 = new MarvinImageMask(this.imageIn.getWidth(), this.imageIn.getHeight(), 0, this.imageIn.getHeight() / 2, this.imageIn.getWidth(), this.imageIn.getHeight() / 2);
        MarvinThread l_marvinThread_1 = new MarvinThread((MarvinImagePlugin)l_pluginImage_1, this.imageIn, this.imageOut, l_mask1);
        MarvinThread l_marvinThread_2 = new MarvinThread((MarvinImagePlugin)l_pluginImage_2, this.imageIn, this.imageOut, l_mask2);
        l_marvinThread_1.addThreadListener((MarvinThreadListener)this);
        l_marvinThread_2.addThreadListener((MarvinThreadListener)this);
        l_marvinThread_1.start();
        l_marvinThread_2.start();
        this.threadsFinished = 0;
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Multithread.this.imageIn = Multithread.this.originalImage.clone();
            if (e.getSource() == Multithread.this.buttonSingleThread) {
                Multithread.this.singleThread();
            } else if (e.getSource() == Multithread.this.buttonMultiThread) {
                Multithread.this.multiThread();
            } else if (e.getSource() == Multithread.this.buttonResetImage) {
                Multithread.this.imagePanel.setImage(Multithread.this.originalImage);
            }
        }
    }
}

