/*
 * Decompiled with CFR 0.152.
 */
package plugin.usage.moravec;

import java.awt.Color;
import marvin.image.MarvinImage;
import marvin.io.MarvinImageIO;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.corner.moravec.Moravec;

public class MoravecExample {
    public static void main(String[] args) {
        Moravec moravec = new Moravec();
        moravec.load();
        moravec.setAttribute("threshold", (Object)50000);
        MarvinImage imageIn = MarvinImageIO.loadImage((String)"src/main/resources/moravec.png");
        MarvinAttributes attr = new MarvinAttributes();
        moravec.process(imageIn, null, attr);
        imageIn = MoravecExample.showCorners(imageIn, attr, 6);
        MarvinImageIO.saveImage((MarvinImage)imageIn, (String)"src/main/resources/moravec_out.png");
        moravec.setAttribute("threshold", (Object)2000);
        moravec.setAttribute("matrixSize", (Object)7);
        imageIn = MarvinImageIO.loadImage((String)"src/main/resources/alan.jpg");
        attr = new MarvinAttributes();
        moravec.process(imageIn, null, attr);
        imageIn = MoravecExample.showCorners(imageIn, attr, 3);
        MarvinImageIO.saveImage((MarvinImage)imageIn, (String)"src/main/resources/alanOut.png");
        moravec.setAttribute("threshold", (Object)1500);
        moravec.setAttribute("matrixSize", (Object)7);
        imageIn = MarvinImageIO.loadImage((String)"src/main/resources/cards.jpg");
        attr = new MarvinAttributes();
        moravec.process(imageIn, null, attr);
        imageIn = MoravecExample.showCorners(imageIn, attr, 3);
        MarvinImageIO.saveImage((MarvinImage)imageIn, (String)"src/main/resources/cardsOut.png");
    }

    private static MarvinImage showCorners(MarvinImage image, MarvinAttributes attr, int rectSize) {
        MarvinImage ret = image.clone();
        int[][] cornernessMap = (int[][])attr.get("cornernessMap");
        int rsize = 0;
        for (int x = 0; x < cornernessMap.length; ++x) {
            for (int y = 0; y < cornernessMap[0].length; ++y) {
                if (cornernessMap[x][y] <= 0) continue;
                rsize = Math.min(Math.min(Math.min(x, rectSize), Math.min(cornernessMap.length - x, rectSize)), Math.min(Math.min(y, rectSize), Math.min(cornernessMap[0].length - y, rectSize)));
                ret.fillRect(x, y, rsize, rsize, Color.red);
            }
        }
        return ret;
    }
}

