/*
 * Decompiled with CFR 0.152.
 */
package video.chromaKey;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.io.MarvinImageIO;
import marvin.plugin.MarvinImagePlugin;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.marvinproject.image.combine.combineByMask.CombineByMask;
import org.marvinproject.image.subtract.Subtract;
import org.marvinproject.image.transform.scale.Scale;

public class ChromaKey
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 6971196346555334548L;
    private JPanel panelBottom;
    private JPanel panelSlider;
    private JSlider sliderColorRange;
    private JButton buttonCaptureBackground;
    private JButton buttonStart;
    private JLabel labelColorRange;
    private MarvinVideoInterface videoInterface;
    private MarvinImagePanel videoPanel;
    private boolean playing;
    private boolean removeBackground;
    private Thread thread;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage imageBackground;
    private MarvinImagePlugin pluginChroma;
    private MarvinImagePlugin pluginCombine;
    private int imageWidth;
    private int imageHeight;
    private int colorRange = 30;

    public ChromaKey() {
        try {
            this.videoPanel = new MarvinImagePanel();
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(1);
            this.imageWidth = this.videoInterface.getImageWidth();
            this.imageHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.imageWidth, this.imageHeight);
            this.loadGUI();
            this.pluginChroma = new Subtract();
            this.pluginChroma.load();
            this.pluginCombine = new CombineByMask();
            this.pluginCombine.load();
            MarvinImage l_imageParadise = MarvinImageIO.loadImage((String)"src/main/resources/paradise.jpg");
            Integer cameraWidth = this.videoInterface.getImageWidth();
            Integer cameraHeight = this.videoInterface.getImageHeight();
            Scale pluginScale = new Scale();
            pluginScale.load();
            pluginScale.setAttribute("newWidth", (Object)cameraWidth);
            pluginScale.setAttribute("newHeight", (Object)cameraHeight);
            MarvinImage l_imageParadiseResize = new MarvinImage(1, 1);
            pluginScale.process(l_imageParadise, l_imageParadiseResize);
            l_imageParadise = l_imageParadiseResize;
            this.pluginCombine.setAttribute("combinationImage", (Object)l_imageParadise);
            this.pluginCombine.setAttribute("colorMask", (Object)new Color(0, 0, 255));
            this.imageBackground = new MarvinImage(cameraWidth.intValue(), cameraHeight.intValue());
            this.thread = new Thread(this);
            this.thread.start();
            this.playing = true;
            this.removeBackground = false;
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Chroma Key Sample");
        this.panelBottom = new JPanel();
        ButtonHandler l_buttonHandler = new ButtonHandler();
        this.buttonCaptureBackground = new JButton("Capture Background");
        this.buttonStart = new JButton("Start");
        this.buttonStart.setEnabled(false);
        this.buttonCaptureBackground.addActionListener(l_buttonHandler);
        this.buttonStart.addActionListener(l_buttonHandler);
        this.sliderColorRange = new JSlider(0, 0, 50, 30);
        this.sliderColorRange.setMinorTickSpacing(1);
        this.sliderColorRange.setPaintTicks(true);
        this.sliderColorRange.addChangeListener(new SliderHandler());
        this.labelColorRange = new JLabel("Color Range");
        this.panelSlider = new JPanel();
        this.panelSlider.add(this.labelColorRange);
        this.panelSlider.add(this.sliderColorRange);
        this.panelBottom.add(this.buttonCaptureBackground);
        this.panelBottom.add(this.buttonStart);
        Container l_container = this.getContentPane();
        l_container.setLayout(new BorderLayout());
        l_container.add((Component)this.videoPanel, "North");
        l_container.add((Component)this.panelSlider, "Center");
        l_container.add((Component)this.panelBottom, "South");
        this.setSize(this.videoInterface.getImageWidth(), this.videoInterface.getImageHeight() + 100);
        this.setVisible(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (!this.playing) {
                    continue;
                }
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                if (this.removeBackground) {
                    this.pluginChroma.setAttribute("colorRange", (Object)this.colorRange);
                    this.pluginChroma.process(this.imageIn, this.imageOut);
                    this.pluginCombine.process(this.imageOut, this.imageOut);
                } else {
                    MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                }
                this.videoPanel.setImage(this.imageOut);
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        ChromaKey ck = new ChromaKey();
        ck.setDefaultCloseOperation(3);
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent a_event) {
            ChromaKey.this.colorRange = 50 - ChromaKey.this.sliderColorRange.getValue();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent a_event) {
            if (a_event.getSource() == ChromaKey.this.buttonCaptureBackground) {
                try {
                    MarvinImage.copyColorArray((MarvinImage)ChromaKey.this.videoInterface.getFrame(), (MarvinImage)ChromaKey.this.imageBackground);
                    ChromaKey.this.pluginChroma.setAttribute("backgroundImage", (Object)ChromaKey.this.imageBackground);
                    ChromaKey.this.buttonStart.setEnabled(true);
                }
                catch (MarvinVideoInterfaceException e) {
                    e.printStackTrace();
                }
            } else if (a_event.getSource() == ChromaKey.this.buttonStart) {
                ChromaKey.this.removeBackground = true;
            }
        }
    }
}

