/*
 * Decompiled with CFR 0.152.
 */
package video.detectMotionRegions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.marvinproject.image.difference.differentRegions.DifferentRegions;

public class DetectMotionRegions
extends JFrame
implements Runnable {
    private static final long serialVersionUID = -1992437126562575898L;
    private JPanel panelSlider;
    private JSlider sliderSensibility;
    private JLabel labelSlider;
    private MarvinVideoInterface videoInterface;
    private MarvinImagePanel videoPanel;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage imageLastFrame;
    private int imageWidth;
    private int imageHeight;
    private MarvinAttributes attributesOut;
    private Thread thread;
    private MarvinImagePlugin pluginMotionRegions;
    private int sensibility = 30;

    public DetectMotionRegions() {
        try {
            this.videoPanel = new MarvinImagePanel();
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(0);
            this.imageWidth = this.videoInterface.getImageWidth();
            this.imageHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.imageWidth, this.imageHeight);
            this.imageLastFrame = new MarvinImage(this.imageWidth, this.imageHeight);
            this.attributesOut = new MarvinAttributes(null);
            this.pluginMotionRegions = new DifferentRegions();
            this.pluginMotionRegions.load();
            this.pluginMotionRegions.setAttribute("comparisonImage", (Object)this.imageLastFrame);
            this.loadGUI();
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Video Sample - Detect Motion Regions");
        this.sliderSensibility = new JSlider(0, 0, 60, 30);
        this.sliderSensibility.setMinorTickSpacing(2);
        this.sliderSensibility.setPaintTicks(true);
        this.sliderSensibility.addChangeListener(new SliderHandler());
        this.labelSlider = new JLabel("Sensibility");
        this.panelSlider = new JPanel();
        this.panelSlider.add(this.labelSlider);
        this.panelSlider.add(this.sliderSensibility);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.videoPanel, "North");
        container.add((Component)this.panelSlider, "South");
        this.setSize(this.imageWidth + 10, this.imageHeight + 100);
        this.setVisible(true);
    }

    @Override
    public void run() {
        boolean first = true;
        try {
            while (true) {
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                if (!first) {
                    this.pluginMotionRegions.setAttribute("comparisonImage", (Object)this.imageLastFrame);
                    this.pluginMotionRegions.setAttribute("colorRange", (Object)this.sensibility);
                    MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                    this.pluginMotionRegions.process(this.imageIn, this.imageOut, this.attributesOut, MarvinImageMask.NULL_MASK, false);
                    Vector regions = (Vector)this.attributesOut.get("regions");
                    for (int i = 0; i < regions.size(); ++i) {
                        int[] tempRect = (int[])regions.get(i);
                        this.imageOut.drawRect(tempRect[0], tempRect[1], tempRect[2] - tempRect[0], tempRect[3] - tempRect[1], Color.GREEN);
                        this.imageOut.drawRect(tempRect[0] + 1, tempRect[1] + 1, tempRect[2] - tempRect[0] - 2, tempRect[3] - tempRect[1] - 2, Color.GREEN);
                    }
                    this.videoPanel.setImage(this.imageOut);
                    MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageLastFrame);
                }
                first = false;
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        DetectMotionRegions dmr = new DetectMotionRegions();
        dmr.setDefaultCloseOperation(3);
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent a_event) {
            DetectMotionRegions.this.sensibility = 60 - DetectMotionRegions.this.sliderSensibility.getValue();
        }
    }
}

