/*
 * Decompiled with CFR 0.152.
 */
package video.objectTracking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.marvinproject.image.pattern.findColorPattern.FindColorPattern;

public class ObjectTracking
extends JFrame
implements Runnable {
    private static final long serialVersionUID = -5406798825093129109L;
    private MarvinVideoInterface videoInterface;
    private MarvinImagePanel videoPanel;
    private Thread thread;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private JPanel panelSlider;
    private JSlider sliderSensibility;
    private JLabel labelSlider;
    private MarvinImagePlugin pluginImage;
    private MarvinAttributes attributesOut;
    private int sensibility = 30;
    private int imageWidth;
    private int imageHeight;
    private boolean regionSelected = false;
    private int[] arrInitialRegion;

    public ObjectTracking() {
        try {
            this.videoPanel = new MarvinImagePanel();
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(1);
            this.imageWidth = this.videoInterface.getImageWidth();
            this.imageHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.imageWidth, this.imageHeight);
            this.loadGUI();
            this.pluginImage = new FindColorPattern();
            this.pluginImage.load();
            this.attributesOut = new MarvinAttributes(null);
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Video Sample - Tracking");
        this.videoPanel.addMouseListener((MouseListener)new MouseHandler());
        this.sliderSensibility = new JSlider(0, 0, 60, 30);
        this.sliderSensibility.setMinorTickSpacing(2);
        this.sliderSensibility.setPaintTicks(true);
        this.sliderSensibility.addChangeListener(new SliderHandler());
        this.labelSlider = new JLabel("Sensibility");
        this.panelSlider = new JPanel();
        this.panelSlider.add(this.labelSlider);
        this.panelSlider.add(this.sliderSensibility);
        Container l_container = this.getContentPane();
        l_container.setLayout(new BorderLayout());
        l_container.add((Component)this.videoPanel, "North");
        l_container.add((Component)this.panelSlider, "South");
        this.setSize(this.imageWidth + 20, this.imageHeight + 100);
        this.setVisible(true);
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        int ticks = 0;
        try {
            while (true) {
                ++ticks;
                if (System.currentTimeMillis() - time > 1000L) {
                    System.out.println("FPS: " + ticks + "       ");
                    ticks = 0;
                    time = System.currentTimeMillis();
                }
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                if (this.regionSelected) {
                    this.pluginImage.setAttribute("differenceColorRange", (Object)this.sensibility);
                    this.pluginImage.process(this.imageIn, this.imageOut, this.attributesOut, MarvinImageMask.NULL_MASK, false);
                    this.imageOut.drawRect(((Integer)this.attributesOut.get("regionPx")).intValue(), ((Integer)this.attributesOut.get("regionPy")).intValue(), ((Integer)this.attributesOut.get("regionWidth")).intValue(), ((Integer)this.attributesOut.get("regionHeight")).intValue(), Color.red);
                }
                this.videoPanel.setImage(this.imageOut);
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        ObjectTracking l_objectTracking = new ObjectTracking();
        l_objectTracking.setDefaultCloseOperation(3);
    }

    static /* synthetic */ int[] access$502(ObjectTracking x0, int[] x1) {
        x0.arrInitialRegion = x1;
        return x1;
    }

    private class MouseHandler
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent a_event) {
        }

        @Override
        public void mouseExited(MouseEvent a_event) {
        }

        @Override
        public void mousePressed(MouseEvent a_event) {
        }

        @Override
        public void mouseClicked(MouseEvent a_event) {
        }

        @Override
        public void mouseReleased(MouseEvent a_event) {
            if (!ObjectTracking.this.regionSelected) {
                if (ObjectTracking.this.arrInitialRegion == null) {
                    ObjectTracking.access$502(ObjectTracking.this, new int[]{a_event.getX(), a_event.getY(), 0, 0});
                } else {
                    ((ObjectTracking)ObjectTracking.this).arrInitialRegion[2] = a_event.getX() - ObjectTracking.this.arrInitialRegion[0];
                    ((ObjectTracking)ObjectTracking.this).arrInitialRegion[3] = a_event.getY() - ObjectTracking.this.arrInitialRegion[1];
                    ObjectTracking.this.pluginImage.setAttribute("regionPx", (Object)ObjectTracking.this.arrInitialRegion[0]);
                    ObjectTracking.this.pluginImage.setAttribute("regionPy", (Object)ObjectTracking.this.arrInitialRegion[1]);
                    ObjectTracking.this.pluginImage.setAttribute("regionWidth", (Object)ObjectTracking.this.arrInitialRegion[2]);
                    ObjectTracking.this.pluginImage.setAttribute("regionHeight", (Object)ObjectTracking.this.arrInitialRegion[3]);
                    ObjectTracking.this.regionSelected = true;
                }
            }
        }
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent a_event) {
            ObjectTracking.this.sensibility = 60 - ObjectTracking.this.sliderSensibility.getValue();
        }
    }
}

