/*
 * Decompiled with CFR 0.152.
 */
package video.simpleMotionDetection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;

public class SimpleMotionDetection
extends JFrame
implements Runnable {
    private static final long serialVersionUID = -7700282643247534304L;
    private JPanel panelCenter;
    private JPanel panelSlider;
    private JLabel labelMotion;
    private JLabel labelSlider;
    private JSlider sliderSensibility;
    private MarvinVideoInterface videoInterface;
    private MarvinImagePanel videoPanel;
    private int imageWidth;
    private int imageHeight;
    private Thread thread;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage imageLastFrame;
    private double differencePercentage;
    private int sensibility = 7;

    public SimpleMotionDetection() {
        try {
            this.videoPanel = new MarvinImagePanel();
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(1);
            this.imageWidth = this.videoInterface.getImageWidth();
            this.imageHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.imageWidth, this.imageHeight);
            this.imageLastFrame = new MarvinImage(this.imageWidth, this.imageHeight);
            this.loadGUI();
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Simple Motion Detection");
        this.labelMotion = new JLabel("MOTION: NO");
        this.labelMotion.setOpaque(true);
        this.labelMotion.setHorizontalAlignment(0);
        this.labelMotion.setBackground(Color.red);
        this.labelMotion.setForeground(Color.white);
        this.labelSlider = new JLabel("Sensibility:");
        this.sliderSensibility = new JSlider(0, 0, 13, 10);
        this.sliderSensibility.setMinorTickSpacing(1);
        this.sliderSensibility.setPaintTicks(true);
        this.sliderSensibility.addChangeListener(new SliderHandler());
        this.panelCenter = new JPanel(new BorderLayout());
        this.panelCenter.add((Component)this.videoPanel, "North");
        this.panelCenter.add((Component)this.labelMotion, "South");
        this.panelSlider = new JPanel();
        this.panelSlider.add(this.labelSlider);
        this.panelSlider.add(this.sliderSensibility);
        Container l_container = this.getContentPane();
        l_container.add((Component)this.videoPanel, "North");
        l_container.add((Component)this.labelMotion, "Center");
        l_container.add((Component)this.panelSlider, "South");
        this.setSize(this.imageWidth, this.imageHeight + 100);
        this.setVisible(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                this.differencePercentage = this.getDifference(this.imageLastFrame, this.imageIn);
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                MarvinImage.copyColorArray((MarvinImage)this.imageOut, (MarvinImage)this.imageLastFrame);
                this.videoPanel.setImage(this.imageOut);
                if (this.differencePercentage > (double)this.sensibility) {
                    this.labelMotion.setBackground(Color.green);
                    this.labelMotion.setForeground(Color.white);
                    this.labelMotion.setText("MOTION: YES");
                    continue;
                }
                this.labelMotion.setBackground(Color.red);
                this.labelMotion.setForeground(Color.white);
                this.labelMotion.setText("MOTION: NO");
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    private double getDifference(MarvinImage a_imageA, MarvinImage a_imageB) {
        double l_pixels = 0.0;
        for (int y = 0; y < a_imageA.getHeight(); ++y) {
            for (int x = 0; x < a_imageA.getWidth(); ++x) {
                int l_redA = a_imageA.getIntComponent0(x, y);
                int l_greenA = a_imageA.getIntComponent1(x, y);
                int l_blueA = a_imageA.getIntComponent2(x, y);
                int l_redB = a_imageB.getIntComponent0(x, y);
                int l_greenB = a_imageB.getIntComponent1(x, y);
                int l_blueB = a_imageB.getIntComponent2(x, y);
                if (Math.abs(l_redA - l_redB) <= 20 && Math.abs(l_greenA - l_greenB) <= 20 && Math.abs(l_blueA - l_blueB) <= 20) continue;
                l_pixels += 1.0;
            }
        }
        return l_pixels / (double)(a_imageA.getWidth() * a_imageA.getHeight()) * 100.0;
    }

    public static void main(String[] args) {
        SimpleMotionDetection smd = new SimpleMotionDetection();
        smd.setDefaultCloseOperation(3);
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent a_event) {
            SimpleMotionDetection.this.sensibility = 15 - SimpleMotionDetection.this.sliderSensibility.getValue();
        }
    }
}

