/*
 * Decompiled with CFR 0.152.
 */
package video.snookerBallPath;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;

public class MediaFileExample
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 5758835478234663768L;
    private MarvinVideoInterface videoAdapter;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage imageBuffer;
    private MarvinImagePanel videoPanelLeft;
    private MarvinImagePanel videoPanelRight;
    private static FlowLayout flowLayout = new FlowLayout(1);
    int fc = 0;

    public MediaFileExample() {
        super("Media File Example");
        try {
            this.videoAdapter = new MarvinJavaCVAdapter();
            this.videoAdapter.loadResource("src/main/resources/snooker.wmv");
            this.imageOut = new MarvinImage(this.videoAdapter.getImageWidth(), this.videoAdapter.getImageHeight());
            this.imageBuffer = new MarvinImage(this.videoAdapter.getImageWidth(), this.videoAdapter.getImageHeight());
            this.loadGUI();
            new Thread(this).start();
            this.setSize(this.videoAdapter.getImageWidth() * 2 + 10, this.videoAdapter.getImageHeight() + 80);
            this.setVisible(true);
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MediaFileExample m = new MediaFileExample();
        m.setDefaultCloseOperation(3);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.imageIn = this.videoAdapter.getFrame();
                if (this.imageIn != null) {
                    this.videoPanelLeft.setImage(this.imageIn);
                    this.processImage(this.imageIn, this.imageOut);
                    this.videoPanelRight.setImage(this.imageOut);
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void processImage(MarvinImage imgIn, MarvinImage imgOut) {
        int x;
        int y;
        if (++this.fc == 8) {
            for (y = 0; y < imgIn.getHeight(); ++y) {
                for (x = 0; x < imgIn.getWidth(); ++x) {
                    int red = imgIn.getIntComponent0(x, y);
                    int green = imgIn.getIntComponent1(x, y);
                    int blue = imgIn.getIntComponent2(x, y);
                    if (green > 120 && (double)green > (double)red * 1.4 && blue < 50) continue;
                    this.imageBuffer.setIntColor(x, y, 255, red, green, blue);
                }
            }
            this.fc = 0;
        }
        for (y = 0; y < imgIn.getHeight(); ++y) {
            for (x = 0; x < imgIn.getWidth(); ++x) {
                if (this.imageBuffer.getAlphaComponent(x, y) == 255) {
                    imgOut.setIntColor(x, y, this.imageBuffer.getIntColor(x, y));
                    continue;
                }
                imgOut.setIntColor(x, y, this.imageIn.getIntColor(x, y));
            }
        }
    }

    private void loadGUI() {
        this.videoPanelLeft = new MarvinImagePanel();
        this.videoPanelRight = new MarvinImagePanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.videoPanelLeft, "West");
        this.add((Component)this.videoPanelRight, "East");
        GridLayout grid = new GridLayout(1, 2);
        JPanel panelTop = new JPanel(grid);
        JPanel p1 = new JPanel(flowLayout);
        p1.add(new JLabel("ORIGINAL"));
        JPanel p2 = new JPanel(flowLayout);
        p2.add(new JLabel("PROCESSED"));
        panelTop.add(p1);
        panelTop.add(p2);
        this.add((Component)panelTop, "North");
    }
}

