/*
 * Decompiled with CFR 0.152.
 */
package video.trackingGameBalls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.io.MarvinImageIO;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.marvinproject.image.pattern.findColorPattern.FindColorPattern;
import org.marvinproject.image.render.renderText.RenderText;

public class TrackingGameBalls
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 366415065001447545L;
    private MarvinVideoInterface videoInterface;
    private MarvinImagePanel videoPanel;
    private Thread thread;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage imageHat;
    private MarvinImage imageBall;
    private JPanel panelSlider;
    private JSlider sliderSensibility;
    private JButton buttonStart;
    private JLabel labelSlider;
    private int regionPx;
    private int regionPy;
    private int sensibility = 30;
    private int playerPoints = 15;
    private boolean regionSelected = false;
    private Ball[] arrBall;
    private int imageWidth;
    private int imageHeight;
    private int maskPx;
    private int maskPy;
    private int maskWidth = 120;
    private int maskHeight = 60;
    private MarvinImagePlugin pluginColorPattern;
    private MarvinImagePlugin text;
    private MarvinAttributes attributesOut;
    private long lastBall = 0L;
    private static final int BALL_DELAY = 1000;
    private long currentTime;

    public TrackingGameBalls() {
        try {
            this.videoPanel = new MarvinImagePanel();
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(1);
            this.imageWidth = this.videoInterface.getImageWidth();
            this.imageHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.imageWidth, this.imageHeight);
            this.imageHat = MarvinImageIO.loadImage((String)"src/main/resources/hat.png");
            this.imageBall = MarvinImageIO.loadImage((String)"src/main/resources/ball.png");
            this.loadGUI();
            this.arrBall = new Ball[5];
            for (int l_i = 0; l_i < 5; ++l_i) {
                this.arrBall[l_i] = new Ball();
                this.arrBall[l_i].used = false;
            }
            this.pluginColorPattern = new FindColorPattern();
            this.pluginColorPattern.load();
            this.text = new RenderText();
            this.text.load();
            this.text.setAttribute("fontFile", (Object)MarvinImageIO.loadImage((String)"src/main/resources/font.png"));
            this.text.setAttribute("color", (Object)-1);
            this.attributesOut = new MarvinAttributes(null);
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Video Sample - Tracking Game");
        this.sliderSensibility = new JSlider(0, 0, 60, 30);
        this.sliderSensibility.setMinorTickSpacing(2);
        this.sliderSensibility.setPaintTicks(true);
        this.sliderSensibility.addChangeListener(new SliderHandler());
        this.labelSlider = new JLabel("Sensibility");
        this.panelSlider = new JPanel();
        this.panelSlider.add(this.labelSlider);
        this.panelSlider.add(this.sliderSensibility);
        this.buttonStart = new JButton("Start");
        this.buttonStart.addActionListener(new ButtonHandler());
        Container l_container = this.getContentPane();
        l_container.setLayout(new BorderLayout());
        l_container.add((Component)this.videoPanel, "North");
        l_container.add((Component)this.panelSlider, "Center");
        l_container.add((Component)this.buttonStart, "South");
        this.setSize(this.imageWidth + 20, this.imageHeight + 100);
        this.setVisible(true);
    }

    private void combineImage(MarvinImage a_image, int x, int y) {
        int l_width = a_image.getWidth();
        int l_height = a_image.getHeight();
        for (int iy = 0; iy < l_height; ++iy) {
            for (int ix = 0; ix < l_width; ++ix) {
                int l_rgb;
                if (ix + x <= 0 || ix + x >= this.imageWidth || iy + y <= 0 || iy + y >= this.imageHeight || (l_rgb = a_image.getIntColor(ix, iy)) == -1) continue;
                this.imageOut.setIntColor(ix + x, iy + y, l_rgb);
            }
        }
    }

    private void updateBalls() {
        this.currentTime = System.currentTimeMillis();
        if (this.currentTime - this.lastBall > 1000L) {
            this.launchBall();
            this.lastBall = this.currentTime;
        }
        for (int l_i = 0; l_i < 5; ++l_i) {
            if (!this.arrBall[l_i].used) continue;
            this.arrBall[l_i].py *= 1.1;
            this.combineImage(this.imageBall, (int)this.arrBall[l_i].px, (int)this.arrBall[l_i].py);
        }
    }

    private void launchBall() {
        for (int l_i = 0; l_i < 5; ++l_i) {
            if (this.arrBall[l_i].used) continue;
            this.arrBall[l_i].py = 1.0;
            this.arrBall[l_i].px = Math.random() * (double)(this.imageWidth - 300) + 150.0;
            this.arrBall[l_i].used = true;
            return;
        }
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        int ticks = 0;
        try {
            while (true) {
                ++ticks;
                if (System.currentTimeMillis() - time > 1000L) {
                    System.out.println("FPS: " + ticks + "       ");
                    ticks = 0;
                    time = System.currentTimeMillis();
                }
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                if (this.regionSelected) {
                    this.pluginColorPattern.setAttribute("differenceColorRange", (Object)this.sensibility);
                    this.pluginColorPattern.process(this.imageIn, this.imageOut, this.attributesOut, MarvinImageMask.NULL_MASK, false);
                    this.regionPx = (Integer)this.attributesOut.get("regionPx");
                    this.regionPy = (Integer)this.attributesOut.get("regionPy");
                    this.gameLoop();
                } else {
                    this.combineImage(this.imageHat, 300, 200);
                }
                this.text.setAttribute("y", (Object)5);
                this.text.setAttribute("text", (Object)("POINTS:" + this.playerPoints));
                this.text.process(this.imageOut, this.imageOut);
                this.videoPanel.setImage(this.imageOut);
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    private void gameLoop() {
        this.maskPx = this.regionPx - 12;
        this.maskPy = this.regionPy - 58;
        this.updateBalls();
        this.collisionDetection();
        this.combineImage(this.imageHat, this.regionPx - 14, this.regionPy - 95);
    }

    public void collisionDetection() {
        for (int l_i = 0; l_i < 5; ++l_i) {
            if (!this.arrBall[l_i].used) continue;
            this.collisionBallMask(this.arrBall[l_i]);
            this.collisionBallScreen(this.arrBall[l_i]);
        }
    }

    private void collisionBallScreen(Ball a_ball) {
        if (a_ball.py > (double)this.imageHeight) {
            a_ball.used = false;
        }
    }

    private void collisionBallMask(Ball a_ball) {
        if ((a_ball.px >= (double)this.maskPx && a_ball.px <= (double)(this.maskPx + this.maskWidth) || a_ball.px <= (double)this.maskPx && a_ball.px + (double)a_ball.width >= (double)this.maskPx) && (a_ball.py >= (double)this.maskPy && a_ball.py <= (double)(this.maskPy + this.maskHeight) || a_ball.py <= (double)this.maskPy && a_ball.py + (double)a_ball.height >= (double)this.maskPy)) {
            a_ball.used = false;
        }
    }

    public static void main(String[] args) {
        TrackingGameBalls l_trackingBalls = new TrackingGameBalls();
        l_trackingBalls.setDefaultCloseOperation(3);
    }

    private class Ball {
        public boolean used;
        public double px;
        public double py;
        public int width;
        public int height;

        private Ball() {
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent a_event) {
            TrackingGameBalls.this.pluginColorPattern.setAttribute("regionPx", (Object)310);
            TrackingGameBalls.this.pluginColorPattern.setAttribute("regionPy", (Object)295);
            TrackingGameBalls.this.pluginColorPattern.setAttribute("regionWidth", (Object)118);
            TrackingGameBalls.this.pluginColorPattern.setAttribute("regionHeight", (Object)134);
            TrackingGameBalls.this.regionSelected = true;
        }
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent a_event) {
            TrackingGameBalls.this.sensibility = 60 - TrackingGameBalls.this.sliderSensibility.getValue();
        }
    }
}

