/*
 * Decompiled with CFR 0.152.
 */
package video.trackingPong;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.io.MarvinImageIO;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.marvinproject.image.pattern.findColorPattern.FindColorPattern;
import org.marvinproject.image.render.renderText.RenderText;
import org.marvinproject.image.transform.flip.Flip;

public class TrackingPong
extends JFrame
implements Runnable {
    private static final long serialVersionUID = -1478144211763350780L;
    private static final int BALL_INITIAL_PX = 100;
    private static final int BALL_INITIAL_PY = 100;
    private static final int BALL_INITIAL_SPEED = 3;
    private MarvinVideoInterface videoInterface;
    private MarvinImagePanel videoPanel = new MarvinImagePanel();
    private Thread thread;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private JPanel panelSlider;
    private JSlider sliderSensibility;
    private JLabel labelSlider;
    private int regionPx;
    private int regionPy;
    private int regionWidth;
    private int regionHeight;
    private boolean regionSelected = false;
    private int[] arrInitialRegion;
    private int sensibility = 30;
    private double ballPx = 100.0;
    private double ballPy = 100.0;
    private int ballSide = 15;
    double ballIncX = 5.0;
    private double ballIncY = 5.0;
    private int imageWidth;
    private int imageHeight;
    private Paddle paddlePlayer;
    private Paddle paddleComputer;
    private int playerPoints = 0;
    private int computerPoints = 0;
    private MarvinImagePlugin findColorPattern;
    private MarvinImagePlugin flip;
    private MarvinImagePlugin text;
    private MarvinImage imageBall;
    private MarvinImage imagePaddlePlayer;
    private MarvinImage imagePaddleComputer;
    private MarvinAttributes attributesOut;
    private int horizontalMargin = 100;

    public TrackingPong() {
        try {
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(1);
            this.imageWidth = this.videoInterface.getImageWidth();
            this.imageHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.imageWidth, this.imageHeight);
            this.loadGUI();
            this.findColorPattern = new FindColorPattern();
            this.findColorPattern.load();
            this.flip = new Flip();
            this.flip.load();
            this.text = new RenderText();
            this.text.load();
            this.text.setAttribute("fontFile", (Object)MarvinImageIO.loadImage((String)"src/main/resources/font.png"));
            this.text.setAttribute("color", (Object)-1);
            this.imageBall = MarvinImageIO.loadImage((String)"src/main/resources/ball.png");
            this.imagePaddlePlayer = MarvinImageIO.loadImage((String)"src/main/resources/paddleA.png");
            this.imagePaddleComputer = MarvinImageIO.loadImage((String)"src/main/resources/paddleB.png");
            this.attributesOut = new MarvinAttributes(null);
            this.paddlePlayer = new Paddle();
            this.paddlePlayer.px = 100;
            this.paddlePlayer.py = 420;
            this.paddlePlayer.width = 100;
            this.paddlePlayer.height = 30;
            this.paddleComputer = new Paddle();
            this.paddleComputer.px = 100;
            this.paddleComputer.py = 30;
            this.paddleComputer.width = 100;
            this.paddleComputer.height = 30;
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Video Sample - Tracking Pong");
        this.videoPanel.addMouseListener((MouseListener)new MouseHandler());
        this.sliderSensibility = new JSlider(0, 0, 60, 30);
        this.sliderSensibility.setMinorTickSpacing(2);
        this.sliderSensibility.setPaintTicks(true);
        this.sliderSensibility.addChangeListener(new SliderHandler());
        this.labelSlider = new JLabel("Sensibility");
        this.panelSlider = new JPanel();
        this.panelSlider.add(this.labelSlider);
        this.panelSlider.add(this.sliderSensibility);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.videoPanel, "North");
        container.add((Component)this.panelSlider, "South");
        this.setSize(this.videoInterface.getImageWidth() + 20, this.videoInterface.getImageHeight() + 100);
        this.setVisible(true);
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        int ticks = 0;
        try {
            while (true) {
                ++ticks;
                if (System.currentTimeMillis() - time > 1000L) {
                    System.out.println("FPS: " + ticks + "       ");
                    ticks = 0;
                    time = System.currentTimeMillis();
                }
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                this.flip.process(this.imageOut, this.imageOut);
                if (this.regionSelected) {
                    this.findColorPattern.setAttribute("differenceColorRange", (Object)this.sensibility);
                    this.findColorPattern.process(this.imageOut, this.imageOut, this.attributesOut, MarvinImageMask.NULL_MASK, false);
                    this.regionPx = (Integer)this.attributesOut.get("regionPx");
                    this.regionPy = (Integer)this.attributesOut.get("regionPy");
                    this.regionWidth = (Integer)this.attributesOut.get("regionWidth");
                    this.regionHeight = (Integer)this.attributesOut.get("regionHeight");
                    this.pongGame();
                    this.imageOut.drawRect(this.regionPx, this.regionPy, this.regionWidth, this.regionHeight, Color.red);
                    this.text.setAttribute("x", (Object)105);
                    this.text.setAttribute("y", (Object)3);
                    this.text.setAttribute("text", (Object)("PLAYER:" + this.playerPoints));
                    this.text.process(this.imageOut, this.imageOut);
                    this.text.setAttribute("x", (Object)105);
                    this.text.setAttribute("y", (Object)460);
                    this.text.setAttribute("text", (Object)("COMPUTER:" + this.computerPoints));
                    this.text.process(this.imageOut, this.imageOut);
                }
                this.videoPanel.setImage(this.imageOut);
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    private void pongGame() {
        this.ballIncX *= 1.001;
        this.ballIncY *= 1.001;
        this.ballPx += this.ballIncX;
        this.ballPy += this.ballIncY;
        this.paddlePlayer.px = this.regionPx + (this.regionWidth - this.paddlePlayer.width) / 2;
        this.computerAI();
        this.checkPaddlePosition(this.paddlePlayer);
        this.checkPaddlePosition(this.paddleComputer);
        this.collisionScreen();
        this.collisionTap();
        this.imageOut.fillRect(this.horizontalMargin, 0, 5, this.imageHeight, Color.black);
        this.imageOut.fillRect(this.imageWidth - this.horizontalMargin, 0, 5, this.imageHeight, Color.black);
        this.combineImage(this.imagePaddlePlayer, this.paddlePlayer.px, this.paddlePlayer.py);
        this.combineImage(this.imagePaddleComputer, this.paddleComputer.px, this.paddleComputer.py);
        this.combineImage(this.imageBall, (int)this.ballPx, (int)this.ballPy);
    }

    private void checkPaddlePosition(Paddle a_paddle) {
        if (a_paddle.px < this.horizontalMargin) {
            a_paddle.px = this.horizontalMargin;
        }
        if (a_paddle.px + a_paddle.width > this.imageWidth - this.horizontalMargin) {
            a_paddle.px = this.imageWidth - this.horizontalMargin - a_paddle.width;
        }
    }

    private void computerAI() {
        if (this.ballPx < (double)(this.paddleComputer.px + this.paddleComputer.width / 2 - 10)) {
            this.paddleComputer.px -= 4;
        }
        if (this.ballPx > (double)(this.paddleComputer.px + this.paddleComputer.width / 2 + 10)) {
            this.paddleComputer.px += 4;
        }
    }

    private void collisionScreen() {
        if (this.ballPx < (double)this.horizontalMargin) {
            this.ballPx = this.horizontalMargin;
            this.ballIncX *= -1.0;
        }
        if (this.ballPx + (double)this.ballSide >= (double)(this.imageWidth - this.horizontalMargin)) {
            this.ballPx = this.imageWidth - this.horizontalMargin - this.ballSide;
            this.ballIncX *= -1.0;
        }
        if (this.ballPy < 0.0) {
            ++this.playerPoints;
            this.ballPx = 100.0;
            this.ballPy = 100.0;
            this.ballIncY = 3.0;
            this.ballIncX = 3.0;
        } else if (this.ballPy + (double)this.ballSide >= (double)this.imageHeight) {
            ++this.computerPoints;
            this.ballPx = 100.0;
            this.ballPy = 100.0;
            this.ballIncY = 3.0;
            this.ballIncX = 3.0;
        }
    }

    private void collisionTap() {
        if (this.ballCollisionTap(this.paddlePlayer)) {
            this.ballIncY *= -1.0;
            this.ballPy = this.paddlePlayer.py - this.ballSide;
        }
        if (this.ballCollisionTap(this.paddleComputer)) {
            this.ballIncY *= -1.0;
            this.ballPy = this.paddleComputer.py + this.paddleComputer.height;
        }
    }

    private boolean ballCollisionTap(Paddle a_tap) {
        return (this.ballPx >= (double)a_tap.px && this.ballPx <= (double)(a_tap.px + a_tap.width) || this.ballPx <= (double)a_tap.px && this.ballPx + (double)this.ballSide >= (double)a_tap.px) && (this.ballPy >= (double)a_tap.py && this.ballPy <= (double)(a_tap.py + a_tap.height) || this.ballPy <= (double)a_tap.py && this.ballPy + (double)this.ballSide >= (double)a_tap.py);
    }

    private void combineImage(MarvinImage img, int x, int y) {
        int width = img.getWidth();
        int height = img.getHeight();
        for (int iy = 0; iy < height; ++iy) {
            for (int ix = 0; ix < width; ++ix) {
                int rgb;
                if (ix + x <= 0 || ix + x >= this.imageWidth || iy + y <= 0 || iy + y >= this.imageHeight || (rgb = img.getIntColor(ix, iy)) == -1) continue;
                this.imageOut.setIntColor(ix + x, iy + y, rgb);
            }
        }
    }

    public static void main(String[] args) {
        TrackingPong trackingPong = new TrackingPong();
        trackingPong.setDefaultCloseOperation(3);
    }

    static /* synthetic */ int[] access$602(TrackingPong x0, int[] x1) {
        x0.arrInitialRegion = x1;
        return x1;
    }

    private class Paddle {
        public int px;
        public int py;
        public int width;
        public int height;

        private Paddle() {
        }
    }

    private class MouseHandler
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent a_event) {
        }

        @Override
        public void mouseExited(MouseEvent a_event) {
        }

        @Override
        public void mousePressed(MouseEvent a_event) {
        }

        @Override
        public void mouseClicked(MouseEvent a_event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!TrackingPong.this.regionSelected) {
                if (TrackingPong.this.arrInitialRegion == null) {
                    TrackingPong.access$602(TrackingPong.this, new int[]{event.getX(), event.getY(), 0, 0});
                } else {
                    ((TrackingPong)TrackingPong.this).arrInitialRegion[2] = event.getX() - TrackingPong.this.arrInitialRegion[0];
                    ((TrackingPong)TrackingPong.this).arrInitialRegion[3] = event.getY() - TrackingPong.this.arrInitialRegion[1];
                    TrackingPong.this.findColorPattern.setAttribute("regionPx", (Object)TrackingPong.this.arrInitialRegion[0]);
                    TrackingPong.this.findColorPattern.setAttribute("regionPy", (Object)TrackingPong.this.arrInitialRegion[1]);
                    TrackingPong.this.findColorPattern.setAttribute("regionWidth", (Object)TrackingPong.this.arrInitialRegion[2]);
                    TrackingPong.this.findColorPattern.setAttribute("regionHeight", (Object)TrackingPong.this.arrInitialRegion[3]);
                    TrackingPong.this.regionSelected = true;
                }
            }
        }
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent a_event) {
            TrackingPong.this.sensibility = 60 - TrackingPong.this.sliderSensibility.getValue();
        }
    }
}

