/*
 * Decompiled with CFR 0.152.
 */
package video.videoFilters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import marvin.gui.MarvinImagePanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinImagePlugin;
import marvin.video.MarvinJavaCVAdapter;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.marvinproject.image.artistic.television.Television;
import org.marvinproject.image.blur.pixelize.Pixelize;
import org.marvinproject.image.color.grayScale.GrayScale;
import org.marvinproject.image.color.invert.Invert;
import org.marvinproject.image.color.sepia.Sepia;
import org.marvinproject.image.color.thresholding.Thresholding;
import org.marvinproject.image.difference.differenceColor.DifferenceColor;
import org.marvinproject.image.edge.edgeDetector.EdgeDetector;
import org.marvinproject.image.halftone.dithering.Dithering;
import org.marvinproject.image.statistical.maximum.Maximum;
import org.marvinproject.image.statistical.minimum.Minimum;
import org.marvinproject.image.transform.flip.Flip;

public class VideoFilters
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 222257647048263441L;
    private JPanel panelButton;
    private JPanel panelWest;
    private JPanel panelLabels;
    private JPanel panelCenter;
    private JButton buttonPlayStop;
    private JButton buttonNormal;
    private JButton buttonPluginGray;
    private JButton buttonPluginSepia;
    private JButton buttonPluginInvert;
    private JButton buttonPluginPixelize;
    private JButton buttonThresholding;
    private JButton buttonPluginHalftone;
    private JButton buttonPluginMinimum;
    private JButton buttonPluginMaximum;
    private JButton buttonPluginFlip;
    private JButton buttonPluginTelevision;
    private JButton buttonPluginEdgeDetector;
    private JButton buttonPluginDifference;
    private JButton buttonRect;
    private JLabel labelCurrentPlugin;
    private JLabel labelFPS;
    private MarvinImagePanel videoPanel;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImage imageLastFrame;
    private MarvinImageMask imageMask;
    private MarvinImageMask imageMaskRect;
    private Thread thread;
    private MarvinImagePlugin pluginImage;
    private int cameraWidth;
    private int cameraHeight;
    private boolean playing;
    private boolean rect;
    private MarvinVideoInterface videoInterface;

    public VideoFilters() {
        try {
            this.videoInterface = new MarvinJavaCVAdapter();
            this.videoInterface.connect(0);
            this.videoPanel = new MarvinImagePanel();
            this.cameraWidth = this.videoInterface.getImageWidth();
            this.cameraHeight = this.videoInterface.getImageHeight();
            this.imageOut = new MarvinImage(this.cameraWidth, this.cameraHeight);
            this.imageLastFrame = new MarvinImage(this.cameraWidth, this.cameraHeight);
            this.imageMask = MarvinImageMask.NULL_MASK;
            this.imageMaskRect = new MarvinImageMask(this.cameraWidth, this.cameraHeight, this.cameraWidth / 4, this.cameraHeight / 4, this.cameraWidth / 2, this.cameraHeight / 2);
            this.rect = false;
            this.loadGUI();
            this.thread = new Thread(this);
            this.thread.start();
            this.playing = true;
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
        }
    }

    private void loadGUI() {
        this.setTitle("Video Sample - Filters");
        this.labelCurrentPlugin = new JLabel("Current plug-in: none");
        this.labelFPS = new JLabel("FPS:   ");
        ButtonHandler l_handler = new ButtonHandler();
        this.buttonPlayStop = new JButton("Stop");
        this.buttonNormal = new JButton("Normal");
        this.buttonPluginGray = new JButton("Gray Scale");
        this.buttonPluginSepia = new JButton("Sepia");
        this.buttonPluginInvert = new JButton("Invert Colors");
        this.buttonPluginPixelize = new JButton("Pixelize");
        this.buttonThresholding = new JButton("Thresholding");
        this.buttonPluginHalftone = new JButton("Halftone");
        this.buttonPluginMinimum = new JButton("Minimum");
        this.buttonPluginMaximum = new JButton("Maximum");
        this.buttonPluginFlip = new JButton("Flip");
        this.buttonPluginTelevision = new JButton("Television");
        this.buttonPluginEdgeDetector = new JButton("Edge Detector");
        this.buttonPluginDifference = new JButton("Difference");
        this.buttonRect = new JButton("Create Rect");
        this.buttonPlayStop.addActionListener(l_handler);
        this.buttonPluginGray.addActionListener(l_handler);
        this.buttonNormal.addActionListener(l_handler);
        this.buttonPluginSepia.addActionListener(l_handler);
        this.buttonPluginInvert.addActionListener(l_handler);
        this.buttonPluginPixelize.addActionListener(l_handler);
        this.buttonThresholding.addActionListener(l_handler);
        this.buttonPluginHalftone.addActionListener(l_handler);
        this.buttonPluginMinimum.addActionListener(l_handler);
        this.buttonPluginMaximum.addActionListener(l_handler);
        this.buttonPluginFlip.addActionListener(l_handler);
        this.buttonPluginTelevision.addActionListener(l_handler);
        this.buttonPluginEdgeDetector.addActionListener(l_handler);
        this.buttonPluginDifference.addActionListener(l_handler);
        this.buttonRect.addActionListener(l_handler);
        this.panelButton = new JPanel();
        this.panelButton.add(this.buttonRect);
        this.panelButton.add(this.buttonPlayStop);
        this.panelWest = new JPanel();
        this.panelWest.setLayout(new GridLayout(15, 1));
        this.panelWest.add(this.buttonNormal);
        this.panelWest.add(this.buttonPluginGray);
        this.panelWest.add(this.buttonPluginSepia);
        this.panelWest.add(this.buttonPluginInvert);
        this.panelWest.add(this.buttonPluginPixelize);
        this.panelWest.add(this.buttonThresholding);
        this.panelWest.add(this.buttonPluginHalftone);
        this.panelWest.add(this.buttonPluginMinimum);
        this.panelWest.add(this.buttonPluginMaximum);
        this.panelWest.add(this.buttonPluginFlip);
        this.panelWest.add(this.buttonPluginTelevision);
        this.panelWest.add(this.buttonPluginEdgeDetector);
        this.panelWest.add(this.buttonPluginDifference);
        this.panelLabels = new JPanel(new FlowLayout(0));
        this.panelLabels.add(this.labelFPS);
        this.panelLabels.add(this.labelCurrentPlugin);
        this.panelCenter = new JPanel(new BorderLayout());
        this.panelCenter.add((Component)this.videoPanel, "North");
        this.panelCenter.add((Component)this.panelLabels, "Center");
        this.panelCenter.add((Component)this.panelButton, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.panelCenter, "Center");
        container.add((Component)this.panelWest, "West");
        this.setSize(this.cameraWidth + 125, this.cameraHeight + 85);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        int ticks = 0;
        try {
            while (true) {
                if (!this.playing) {
                    continue;
                }
                ++ticks;
                if (System.currentTimeMillis() - time > 1000L) {
                    this.labelFPS.setText("FPS: " + ticks + "       ");
                    ticks = 0;
                    time = System.currentTimeMillis();
                }
                this.imageIn = this.videoInterface.getFrame();
                MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                if (this.pluginImage == null || this.rect) {
                    MarvinImage.copyColorArray((MarvinImage)this.imageIn, (MarvinImage)this.imageOut);
                }
                if (this.pluginImage != null) {
                    this.pluginImage.process(this.imageIn, this.imageOut, null, this.imageMask, false);
                }
                this.imageOut.update();
                this.videoPanel.setImage(this.imageOut);
            }
        }
        catch (MarvinVideoInterfaceException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        VideoFilters l_vs = new VideoFilters();
        l_vs.setDefaultCloseOperation(3);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent a_event) {
            if (a_event.getSource() == VideoFilters.this.buttonPlayStop) {
                if (VideoFilters.this.playing) {
                    VideoFilters.this.playing = false;
                    VideoFilters.this.buttonPlayStop.setText("Play");
                } else {
                    VideoFilters.this.playing = true;
                    VideoFilters.this.buttonPlayStop.setText("Stop");
                }
            } else if (a_event.getSource() == VideoFilters.this.buttonNormal) {
                VideoFilters.this.pluginImage = null;
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: none");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginGray) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new GrayScale();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Gray Scale");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginSepia) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Sepia();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Sepia");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginInvert) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Invert();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Negative");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginPixelize) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Pixelize();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Pixelize");
            } else if (a_event.getSource() == VideoFilters.this.buttonThresholding) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Thresholding();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Thresholding");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginHalftone) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Dithering();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Halftone");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginMinimum) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Minimum();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.pluginImage.setAttribute("size", (Object)2);
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Minimum");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginMaximum) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Maximum();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.pluginImage.setAttribute("size", (Object)2);
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Maximum");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginFlip) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Flip();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Flip");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginTelevision) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new Television();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Television");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginEdgeDetector) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new EdgeDetector();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Edge Detector");
            } else if (a_event.getSource() == VideoFilters.this.buttonPluginDifference) {
                VideoFilters.this.pluginImage = (MarvinImagePlugin)new DifferenceColor();
                VideoFilters.this.pluginImage.load();
                VideoFilters.this.pluginImage.setAttribute("comparisonImage", (Object)VideoFilters.this.imageLastFrame);
                VideoFilters.this.labelCurrentPlugin.setText("Current plug-in: Difference");
            } else if (a_event.getSource() == VideoFilters.this.buttonRect) {
                if (VideoFilters.this.rect) {
                    VideoFilters.this.buttonRect.setText("Create Mask");
                    VideoFilters.this.imageMask = MarvinImageMask.NULL_MASK;
                } else {
                    VideoFilters.this.buttonRect.setText("Remove Mask");
                    VideoFilters.this.imageMask = VideoFilters.this.imageMaskRect;
                }
                VideoFilters.this.rect = !VideoFilters.this.rect;
            }
        }
    }
}

