/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.transport;

import com.github.fmjsjx.libnetty.transport.EpollTransportLibrary;
import com.github.fmjsjx.libnetty.transport.KQueueTransportLibrary;
import com.github.fmjsjx.libnetty.transport.NioTransportLibrary;
import com.github.fmjsjx.libnetty.transport.TransportLibrary;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class TransportLibraries {
    private static final Logger log = LoggerFactory.getLogger(TransportLibraries.class);

    private static final boolean isAvailable(Class<?> library) {
        try {
            Method method = library.getMethod("isAvailable", new Class[0]);
            return (Boolean)method.invoke(library, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    static final TransportLibrary getDefault() {
        return DefaultLibraryHolder.defaultLibrary;
    }

    private TransportLibraries() {
    }

    private static final class DefaultLibraryHolder {
        private static final TransportLibrary defaultLibrary;

        private DefaultLibraryHolder() {
        }

        static {
            boolean epollAvailable = false;
            try {
                Class<?> epoll = Class.forName("io.netty.channel.epoll.Epoll");
                epollAvailable = TransportLibraries.isAvailable(epoll);
            }
            catch (ClassNotFoundException e) {
                log.info("Epoll not found, start without optional native library EpollLibrary");
            }
            if (epollAvailable) {
                defaultLibrary = EpollTransportLibrary.getInstance();
            } else {
                boolean kqueueAvailable = false;
                try {
                    Class<?> kqueue = Class.forName("io.netty.channel.kqueue.KQueue");
                    kqueueAvailable = TransportLibraries.isAvailable(kqueue);
                }
                catch (ClassNotFoundException e) {
                    log.info("KQueue not found, start without optional native library KQueueLibrary");
                }
                defaultLibrary = kqueueAvailable ? KQueueTransportLibrary.getInstance() : NioTransportLibrary.getInstance();
            }
        }
    }
}

