/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.transport.io;

import com.github.fmjsjx.libnetty.transport.io.EpollIoTransportLibrary;
import com.github.fmjsjx.libnetty.transport.io.IoTransportLibrary;
import com.github.fmjsjx.libnetty.transport.io.IoUringIoTransportLibrary;
import com.github.fmjsjx.libnetty.transport.io.KQueueIoTransportLibrary;
import com.github.fmjsjx.libnetty.transport.io.NioIoTransportLibrary;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IoTransportLibraries {
    private static final Logger log = LoggerFactory.getLogger(IoTransportLibraries.class);

    private static final boolean isAvailable(Class<?> library) {
        try {
            Method method = library.getMethod("isAvailable", new Class[0]);
            return (Boolean)method.invoke(library, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    static final IoTransportLibrary getDefault() {
        return DefaultLibraryHolder.defaultLibrary;
    }

    private IoTransportLibraries() {
    }

    private static final class DefaultLibraryHolder {
        private static final IoTransportLibrary defaultLibrary;

        private DefaultLibraryHolder() {
        }

        static {
            boolean ioUringAvailable = false;
            try {
                Class<?> ioUring = Class.forName("io.netty.channel.uring.IoUring");
                ioUringAvailable = IoTransportLibraries.isAvailable(ioUring);
            }
            catch (ClassNotFoundException e) {
                log.info("IoUring not found, start without optional native library IoUringLibrary");
            }
            if (ioUringAvailable) {
                defaultLibrary = IoUringIoTransportLibrary.getInstance();
                log.info("io_uring is available, sets the native library IoUringLibrary as the default library");
            } else {
                boolean epollAvailable = false;
                try {
                    Class<?> epoll = Class.forName("io.netty.channel.epoll.Epoll");
                    epollAvailable = IoTransportLibraries.isAvailable(epoll);
                }
                catch (ClassNotFoundException e) {
                    log.info("Epoll not found, start without optional native library EpollLibrary");
                }
                if (epollAvailable) {
                    defaultLibrary = EpollIoTransportLibrary.getInstance();
                    log.info("epoll is available, sets the native library EpollLibrary as the default library");
                } else {
                    boolean kqueueAvailable = false;
                    try {
                        Class<?> kqueue = Class.forName("io.netty.channel.kqueue.KQueue");
                        kqueueAvailable = IoTransportLibraries.isAvailable(kqueue);
                    }
                    catch (ClassNotFoundException e) {
                        log.info("KQueue not found, start without optional native library KQueueLibrary");
                    }
                    if (kqueueAvailable) {
                        defaultLibrary = KQueueIoTransportLibrary.getInstance();
                        log.info("kqueue is available, sets the native library KQueueLibrary as the default library");
                    } else {
                        defaultLibrary = NioIoTransportLibrary.getInstance();
                        log.info("All native libraries are unavailable, sets the NioIoTransportLibrary as the default library");
                    }
                }
            }
        }
    }
}

