/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.transport.io;

import com.github.fmjsjx.libnetty.transport.io.IoTransportLibraries;
import io.netty.channel.Channel;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ServerChannel;
import java.util.concurrent.ThreadFactory;

public interface IoTransportLibrary {
    public static IoTransportLibrary getDefault() {
        return IoTransportLibraries.getDefault();
    }

    public Class<? extends Channel> channelClass();

    public Class<? extends Channel> datagramChannelClass();

    public Class<? extends ServerChannel> serverChannelClass();

    public IoHandlerFactory createIoHandlerFactory();

    default public IoEventLoopGroup createGroup() {
        return new MultiThreadIoEventLoopGroup(this.createIoHandlerFactory());
    }

    default public IoEventLoopGroup createGroup(int nThreads) {
        return new MultiThreadIoEventLoopGroup(nThreads, this.createIoHandlerFactory());
    }

    default public IoEventLoopGroup createGroup(int nThreads, ThreadFactory threadFactory) {
        return new MultiThreadIoEventLoopGroup(nThreads, threadFactory, this.createIoHandlerFactory());
    }
}

