/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class RandomAccessFileUtil {
    private RandomAccessFileUtil() {
    }

    public static String getFileContent(String filePath, int startIndex, int endIndex) {
        return RandomAccessFileUtil.getFileContent(filePath, startIndex, endIndex, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(String filePath, int startIndex, int endIndex, Charset charset) {
        int size = endIndex - startIndex;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(filePath, "r");){
            MappedByteBuffer inputBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, startIndex, size);
            byte[] bs = new byte[size];
            for (int offset = 0; offset < inputBuffer.capacity(); ++offset) {
                bs[offset] = inputBuffer.get(offset);
            }
            String string = new String(bs, charset);
            return string;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

