/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.reflect.simple;

import com.github.houbb.heaven.reflect.api.IField;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;

public class SimpleField
implements IField {
    private Field field;
    private List<Annotation> annotations;
    private String name;
    private String fullName;
    private Class type;
    private int access;
    private Object value;

    @Override
    public List<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    public Optional<Annotation> annotationOpt(Class type) {
        ArgUtil.notNull(type, "type");
        if (CollectionUtil.isEmpty(this.annotations)) {
            return Optional.empty();
        }
        for (Annotation annotation : this.annotations) {
            if (!type.equals(annotation.annotationType())) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    @Override
    public Annotation annotation(Class type) {
        ArgUtil.notNull(type, "type");
        Optional<Annotation> annotationOptional = this.annotationOpt(type);
        return annotationOptional.orElseNull();
    }

    public SimpleField annotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    public SimpleField name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    public SimpleField fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Override
    public Class type() {
        return this.type;
    }

    public SimpleField type(Class type) {
        this.type = type;
        return this;
    }

    @Override
    public int access() {
        return this.access;
    }

    public SimpleField access(int access) {
        this.access = access;
        return this;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public SimpleField value(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Field field() {
        return this.field;
    }

    public SimpleField field(Field field) {
        this.field = field;
        return this;
    }
}

