/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.id.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.id.Id;
import com.github.houbb.heaven.util.id.impl.UUID32;
import java.util.List;

@ThreadSafe
public class UUID8
implements Id {
    private static final char[] CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    @Override
    public String genId() {
        List<String> uuidUnits = this.uuidUnits();
        StringBuilder stringBuilder = new StringBuilder();
        for (String unit : uuidUnits) {
            int x = Integer.parseInt(unit, 16);
            stringBuilder.append(CHARS[x % 62]);
        }
        return stringBuilder.toString();
    }

    private List<String> uuidUnits() {
        String uuid32 = new UUID32().genId();
        int size = 8;
        List<String> units = Guavas.newArrayList(8);
        for (int i = 0; i < 8; ++i) {
            units.add(uuid32.substring(i * 4, i * 4 + 4));
        }
        return units;
    }
}

