/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.github.wasiqb.coteafs.config.exception.CoteafsConfigFileNotFoundException;
import com.github.wasiqb.coteafs.config.exception.CoteafsConfigNotLoadedException;
import com.google.common.base.CaseFormat;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public final class ConfigLoader {
    private static final Logger log = LogManager.getLogger(ConfigLoader.class);

    public static <T> T settings(Class<T> cls) {
        log.trace("Loading settings from Config file...");
        T settings = ConfigLoader.loadSettings(cls);
        return settings;
    }

    private static <T> T loadSettings(Class<T> cls) {
        String path = System.getProperty("coteafs.config", "test-config.yaml");
        URL url = ConfigLoader.class.getClassLoader().getResource(path);
        if (url == null) {
            String msg = "%s not found.";
            throw new CoteafsConfigFileNotFoundException(String.format("%s not found.", path));
        }
        File file = new File(url.getPath());
        String msg = "Started Loading coteafs Settings from location [%s]...";
        log.trace(String.format("Started Loading coteafs Settings from location [%s]...", path));
        Constructor ctor = new Constructor(cls);
        PropertyUtils propertyUtils = new PropertyUtils(){

            public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
                String prop = name;
                if (prop.indexOf(95) > -1) {
                    prop = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, prop);
                }
                return super.getProperty(type, prop);
            }
        };
        ctor.setPropertyUtils(propertyUtils);
        Yaml yaml = new Yaml((BaseConstructor)ctor);
        Object result = null;
        try (FileInputStream in = new FileInputStream(file);){
            result = yaml.load((InputStream)in);
        }
        catch (Exception e) {
            throw new CoteafsConfigNotLoadedException("Error loading config file.", e);
        }
        log.trace("coteafs settings loaded successfully...");
        return (T)result;
    }
}

