/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.github.wasiqb.coteafs.config.error.CoteafsConfigFileNotFoundError;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigNotLoadedError;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.google.common.base.CaseFormat;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class ConfigLoader {
    private String key = "coteafs.config";
    private String value = "test-config.yaml";

    public static ConfigLoader settings() {
        return new ConfigLoader();
    }

    private ConfigLoader() {
    }

    public <T> T load(Class<T> cls) {
        return this.loadSettings(cls);
    }

    public ConfigLoader withDefault(String def) {
        this.value = def;
        return this;
    }

    public ConfigLoader withKey(String configKey) {
        this.key = configKey;
        return this;
    }

    private <T> T loadSettings(Class<T> cls) {
        String path = System.getProperty(this.key, this.value);
        URL url = ConfigLoader.class.getClassLoader().getResource(path);
        if (url != null) {
            File file = new File(url.getPath());
            Constructor ctor = new Constructor(cls);
            PropertyUtils propertyUtils = new PropertyUtils(){

                public Property getProperty(Class<? extends Object> obj, String name) throws IntrospectionException {
                    String propertyName = name;
                    if (propertyName.indexOf(95) > -1) {
                        propertyName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, propertyName);
                    }
                    return super.getProperty(obj, propertyName);
                }
            };
            ctor.setPropertyUtils(propertyUtils);
            Yaml yaml = new Yaml((BaseConstructor)ctor);
            Object result = null;
            try (FileInputStream in = new FileInputStream(file);){
                result = yaml.load((InputStream)in);
            }
            catch (Exception e) {
                ErrorUtil.fail(CoteafsConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
            }
            return (T)result;
        }
        String MSG = "%s not found.";
        ErrorUtil.fail(CoteafsConfigFileNotFoundError.class, (String)String.format("%s not found.", path));
        return null;
    }
}

