/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigFileNotFoundError;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigNotLoadedError;
import com.github.wasiqb.coteafs.config.loader.AbstractConfigLoader;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;

class XmlConfigLoader
extends AbstractConfigLoader {
    XmlConfigLoader(String path) {
        super(path);
    }

    @Override
    public <T> T load(Class<T> cls) {
        try {
            XmlMapper mapper = new XmlMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            return (T)mapper.readValue(new File(this.path), cls);
        }
        catch (FileNotFoundException e) {
            String MSG = "{0} not found.";
            ErrorUtil.fail(CoteafsConfigFileNotFoundError.class, (String)MessageFormat.format("{0} not found.", this.path), (Throwable)e);
        }
        catch (IOException e) {
            ErrorUtil.fail(CoteafsConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
        }
        return null;
    }
}

