/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigNotLoadedError;
import com.github.wasiqb.coteafs.config.loader.AbstractConfigLoader;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import java.io.File;
import java.io.IOException;

class PropertiesConfigLoader
extends AbstractConfigLoader {
    private final JavaPropsMapper mapper = new JavaPropsMapper();

    PropertiesConfigLoader(String path) {
        super(path);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    @Override
    public <T> void create(Class<T> cls) {
        try {
            T obj = cls.newInstance();
            this.mapper.writeValue(new File(this.path), obj);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            ErrorUtil.handleError((String)"com.github.wasiqb", (Throwable)e);
        }
    }

    @Override
    public <T> T load(Class<T> cls) {
        try {
            this.checkAndCreateDefaultConfig(cls);
            return (T)this.mapper.readValue(new File(this.path), cls);
        }
        catch (IOException e) {
            ErrorUtil.fail(CoteafsConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
            return null;
        }
    }
}

