/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigNotLoadedError;
import com.github.wasiqb.coteafs.config.loader.AbstractConfigLoader;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import java.io.File;
import java.io.IOException;

class XmlConfigLoader
extends AbstractConfigLoader {
    private final XmlMapper mapper = new XmlMapper();

    XmlConfigLoader(String path) {
        super(path);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    @Override
    public <T> void create(Class<T> cls) {
        try {
            this.mapper.writeValue(new File(this.path), cls.newInstance());
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            ErrorUtil.handleError((String)"com.github.wasiqb", (Throwable)e);
        }
    }

    @Override
    public <T> T load(Class<T> cls) {
        try {
            this.checkAndCreateDefaultConfig(cls);
            return (T)this.mapper.readValue(new File(this.path), cls);
        }
        catch (IOException e) {
            ErrorUtil.fail(CoteafsConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
            return null;
        }
    }
}

