/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.github.wasiqb.coteafs.config.error.ConfigNotSupportedError;
import com.github.wasiqb.coteafs.config.loader.IConfigSource;
import com.github.wasiqb.coteafs.config.loader.JsonConfigLoader;
import com.github.wasiqb.coteafs.config.loader.PropertiesConfigLoader;
import com.github.wasiqb.coteafs.config.loader.XmlConfigLoader;
import com.github.wasiqb.coteafs.config.loader.YamlConfigLoader;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class ConfigLoader {
    private final String dir = MessageFormat.format("{0}/src/test/resources/", System.getProperty("user.dir"));
    private String key = "coteafs.config";
    private String value = "test-config.yaml";

    public static ConfigLoader settings() {
        return new ConfigLoader();
    }

    private ConfigLoader() {
    }

    public <T> T load(Class<T> cls) {
        IConfigSource config = this.getConfig();
        return config.load(cls);
    }

    public ConfigLoader withDefault(String defaultValue) {
        this.value = defaultValue;
        return this;
    }

    public ConfigLoader withKey(String configKey) {
        this.key = configKey;
        return this;
    }

    private IConfigSource getConfig() {
        String path = this.getConfigPath();
        String ext = path.substring(path.lastIndexOf(46) + 1);
        switch (ext.toLowerCase()) {
            case "yaml": 
            case "yml": {
                return new YamlConfigLoader(path);
            }
            case "json": {
                return new JsonConfigLoader(path);
            }
            case "properties": {
                return new PropertiesConfigLoader(path);
            }
            case "xml": {
                return new XmlConfigLoader(path);
            }
        }
        ErrorUtil.fail(ConfigNotSupportedError.class, (String)MessageFormat.format("This config file format [{0}] is not supported.", ext));
        return null;
    }

    private String getConfigPath() {
        String envPath = System.getenv(this.key);
        return StringUtils.isEmpty((CharSequence)envPath) ? System.getProperty(this.key, MessageFormat.format("{0}{1}", this.dir, this.value)) : envPath;
    }
}

