/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigNotLoadedError;
import com.github.wasiqb.coteafs.config.error.CoteafsConfigNotSavedError;
import com.github.wasiqb.coteafs.config.loader.IConfigSource;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import java.io.File;
import java.io.IOException;

class AbstractConfigLoader
implements IConfigSource {
    ObjectMapper mapper;
    private final String path;

    AbstractConfigLoader(String path) {
        this.path = path;
    }

    @Override
    public <T> void create(Class<T> cls) {
        try {
            T obj = cls.newInstance();
            this.mapper.writeValue(new File(this.path), obj);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            ErrorUtil.fail(CoteafsConfigNotSavedError.class, (String)"Error saving config file.", (Throwable)e);
        }
    }

    @Override
    public <T> T load(Class<T> cls) {
        try {
            this.checkAndCreateDefaultConfig(cls);
            return (T)this.mapper.readValue(new File(this.path), cls);
        }
        catch (IOException e) {
            ErrorUtil.fail(CoteafsConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
            return null;
        }
    }

    private <T> void checkAndCreateDefaultConfig(Class<T> cls) {
        File config = new File(this.path);
        if (!config.exists()) {
            this.create(cls);
        }
    }
}

