/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.github.wasiqb.coteafs.config.error.ConfigNotLoadedError;
import com.github.wasiqb.coteafs.config.error.ConfigNotSavedError;
import com.github.wasiqb.coteafs.config.loader.AbstractConfigLoader;
import com.github.wasiqb.coteafs.config.util.StringSubstituter;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.google.common.base.CaseFormat;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.ScalarNode;

class YamlConfigLoader
extends AbstractConfigLoader {
    YamlConfigLoader(String path) {
        super(path);
    }

    @Override
    public <T> void create(T data) {
        try (FileWriter out = new FileWriter(this.path);){
            Yaml yaml = new Yaml();
            yaml.dump(Objects.requireNonNull(data, "Object can't be null."), (Writer)out);
        }
        catch (IOException e) {
            ErrorUtil.fail(ConfigNotSavedError.class, (String)"Error saving config file.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T load(Class<T> cls) {
        this.checkAndCreateDefaultConfig(cls);
        try (FileInputStream in = new FileInputStream(this.path);){
            Constructor ctor = new Constructor(cls){

                protected String constructScalar(ScalarNode node) {
                    return StringSubstituter.interpolate(node.getValue());
                }
            };
            PropertyUtils propertyUtils = new PropertyUtils(){

                public Property getProperty(Class<?> obj, String name) {
                    String propertyName = name;
                    if (propertyName.indexOf(95) > -1) {
                        propertyName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, propertyName);
                    }
                    return super.getProperty(obj, propertyName);
                }
            };
            ctor.setPropertyUtils(propertyUtils);
            Yaml yaml = new Yaml((BaseConstructor)ctor);
            Object object = yaml.load((InputStream)in);
            return (T)object;
        }
        catch (Exception e) {
            ErrorUtil.fail(ConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
            return null;
        }
    }
}

