/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.config.loader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wasiqb.coteafs.config.error.ConfigNotLoadedError;
import com.github.wasiqb.coteafs.config.error.ConfigNotSavedError;
import com.github.wasiqb.coteafs.config.error.DefaultConfigNotCreatedError;
import com.github.wasiqb.coteafs.config.loader.IConfigSource;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

class AbstractConfigLoader
implements IConfigSource {
    protected final String path;
    ObjectMapper mapper;

    AbstractConfigLoader(String path) {
        this.path = path;
    }

    @Override
    public <T> void create(T data) {
        try {
            this.mapper.writeValue(new File(this.path), Objects.requireNonNull(data, "Object can't be null."));
        }
        catch (IOException e) {
            ErrorUtil.fail(ConfigNotSavedError.class, (String)"Error saving config file.", (Throwable)e);
        }
    }

    @Override
    public <T> T load(Class<T> cls) {
        try {
            this.checkAndCreateDefaultConfig(cls);
            return (T)this.mapper.readValue(new File(this.path), cls);
        }
        catch (IOException e) {
            ErrorUtil.fail(ConfigNotLoadedError.class, (String)"Error loading config file.", (Throwable)e);
            return null;
        }
    }

    protected <T> void checkAndCreateDefaultConfig(Class<T> cls) {
        File config = new File(this.path);
        if (!config.exists()) {
            try {
                T data = cls.newInstance();
                this.create(data);
            }
            catch (IllegalAccessException | InstantiationException e) {
                ErrorUtil.fail(DefaultConfigNotCreatedError.class, (String)"Error loading config file.", (Throwable)e);
            }
        }
    }
}

