/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.formatter;

import com.github.wasiqb.coteafs.services.config.ServiceType;
import com.github.wasiqb.coteafs.services.formatter.JsonPayloadLogger;
import com.github.wasiqb.coteafs.services.formatter.PayloadLogger;
import com.github.wasiqb.coteafs.services.formatter.PayloadType;
import com.github.wasiqb.coteafs.services.formatter.XmlPayloadLogger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PayloadLoggerFactory {
    private static final String LINE;
    private static final Logger LOG;

    public static void log(ServiceType serviceType, PayloadType payloadType, String body) {
        PayloadLogger logger = new JsonPayloadLogger();
        if (serviceType == ServiceType.SOAP) {
            logger = new XmlPayloadLogger();
        }
        LOG.info(LINE);
        LOG.info(payloadType.getType());
        LOG.info(LINE);
        for (String text : logger.getPayload(payloadType, body)) {
            LOG.info(text);
        }
    }

    private PayloadLoggerFactory() {
    }

    static {
        LOG = LogManager.getLogger(PayloadLoggerFactory.class);
        LINE = StringUtils.repeat((String)"=", (int)80);
    }
}

