/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.requests;

import com.github.wasiqb.coteafs.services.requests.RequestAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestElement {
    private final List<RequestAttribute> attributes;
    private final List<RequestElement> childs = new ArrayList<RequestElement>();
    private boolean display = true;
    private final List<RequestElement> list = new ArrayList<RequestElement>();
    private String name;
    private final Map<String, String> namespace;
    private RequestElement parent;
    private String prefix;
    private Object value;

    public static RequestElement create() {
        return new RequestElement();
    }

    public static RequestElement create(String name) {
        return new RequestElement(name);
    }

    public static RequestElement create(String prefix, String name) {
        return new RequestElement(prefix, name);
    }

    private RequestElement() {
        this(null, null);
    }

    private RequestElement(String name) {
        this(null, name);
    }

    private RequestElement(String prefix, String name) {
        this.attributes = new ArrayList<RequestAttribute>();
        this.prefix = prefix;
        this.name = name;
        this.namespace = new HashMap<String, String>();
    }

    public RequestElement addAttribute(RequestAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public RequestElement addElement(RequestElement element) {
        this.list.add(element);
        return this;
    }

    public List<RequestAttribute> attributes() {
        return this.attributes;
    }

    public List<RequestElement> childs() {
        return this.childs;
    }

    public boolean display() {
        return this.display;
    }

    public RequestElement display(boolean shouldDisplay) {
        this.display = shouldDisplay;
        return this;
    }

    public RequestElement getChild(String childName) {
        for (RequestElement child : this.childs) {
            if (!child.name().equalsIgnoreCase(childName)) continue;
            return child;
        }
        return null;
    }

    public List<RequestElement> list() {
        return this.list;
    }

    public String name() {
        return this.name;
    }

    public RequestElement name(String elementName) {
        this.name = elementName;
        return this;
    }

    public RequestElement namespace(String ns, String uri) {
        if (!this.namespace.containsKey(ns)) {
            this.namespace.put(ns, uri);
        }
        return this;
    }

    public Map<String, String> namespaces() {
        return this.namespace;
    }

    public RequestElement parent() {
        return this.parent;
    }

    public RequestElement parent(RequestElement elementParent) {
        if (this.parent == null) {
            this.parent = elementParent;
        }
        if (!elementParent.childs().contains(this)) {
            elementParent.addChild(this);
        }
        return this;
    }

    public String prefix() {
        return this.prefix;
    }

    public RequestElement prefix(String elementPrefix) {
        this.prefix = elementPrefix;
        return this;
    }

    public <T> T value() {
        return (T)this.value;
    }

    public <T> RequestElement value(T elementValue) {
        this.value = elementValue;
        return this.display(this.value != null);
    }

    private RequestElement addChild(RequestElement child) {
        this.childs.add(child);
        if (child.parent() == null || !child.parent().equals(this)) {
            child.parent(this);
        }
        return this;
    }
}

