/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.helper;

import com.github.wasiqb.coteafs.services.config.LoggingSetting;
import com.github.wasiqb.coteafs.services.config.ServiceSetting;
import com.github.wasiqb.coteafs.services.config.ServiceType;
import com.github.wasiqb.coteafs.services.formatter.PayloadLoggerFactory;
import com.github.wasiqb.coteafs.services.formatter.PayloadType;
import com.github.wasiqb.coteafs.services.response.ResponseValueParser;
import com.github.wasiqb.coteafs.services.response.RestResponseValueParser;
import com.github.wasiqb.coteafs.services.response.SoapResponseValueParser;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResponseHandler {
    private static final String LINE;
    private static final Logger LOG;
    private final String name;
    private final Response response;
    private final ServiceSetting setting;

    public ResponseHandler(String name, Response response, ServiceSetting setting) {
        this.name = name;
        this.response = response;
        this.setting = setting;
        this.logResponseInfo();
    }

    public String body() {
        return this.response.asString();
    }

    public Headers headers() {
        return this.response.headers();
    }

    public int statusCode() {
        return this.response.statusCode();
    }

    public String statusLine() {
        return this.response.statusLine();
    }

    public double time() {
        long time = this.response.time();
        return (double)time / 1000.0;
    }

    public <T> Optional<T> valueOf(String expression) {
        ResponseValueParser parser = new SoapResponseValueParser(this.response);
        if (this.setting.getType() == ServiceType.REST) {
            parser = new RestResponseValueParser(this.response);
        }
        return parser.valueOf(this.name, expression);
    }

    private void logHeaders() {
        LoggingSetting logging = this.setting.getLogging();
        if (logging.isLogHeaders()) {
            Headers headers = this.response.headers();
            LOG.info(LINE);
            LOG.info("Response Headers:");
            LOG.info(LINE);
            for (Header header : headers.asList()) {
                LOG.info(String.format("%s: %s", header.getName(), header.getValue()));
            }
        }
    }

    private void logResponse() {
        LoggingSetting logging = this.setting.getLogging();
        if (logging.isLogOnlyResponses()) {
            PayloadLoggerFactory.log(this.setting.getType(), PayloadType.RESPONSE, this.body());
        }
    }

    private void logResponseInfo() {
        LOG.info(String.format("Request executed in [%.2f] secs...", this.time()));
        this.logHeaders();
        this.logResponse();
    }

    static {
        LOG = LogManager.getLogger(ResponseHandler.class);
        LINE = StringUtils.repeat((String)"=", (int)80);
    }
}

