/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.response;

import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.github.wasiqb.coteafs.services.error.RestResponseParsingFailedError;
import com.github.wasiqb.coteafs.services.response.ResponseValueParser;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RestResponseValueParser
implements ResponseValueParser {
    private final Response response;

    public RestResponseValueParser(Response response) {
        this.response = response;
    }

    @Override
    public <T> Optional<T> valueOf(String name, String path) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            ((ValidatableResponse)this.response.then()).root(name);
        }
        JsonPath jsonPath = JsonPath.from((String)this.response.asString());
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        try {
            return Optional.of(jsonPath.get(path));
        }
        catch (Exception e) {
            String message = "Response value parsing failed for [%s] expression.";
            ErrorUtil.fail(RestResponseParsingFailedError.class, (String)String.format("Response value parsing failed for [%s] expression.", path), (Throwable)e);
            return null;
        }
    }
}

