/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.utils;

import com.github.wasiqb.coteafs.error.CoteafsError;
import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ErrorUtils {
    private static final Logger log = LogManager.getLogger(ErrorUtils.class);

    public static <E extends CoteafsError> void fail(Class<E> error, String message) {
        ErrorUtils.fail(error, message, null);
    }

    public static <E extends CoteafsError> void fail(Class<E> error, String message, Throwable ex) {
        try {
            ErrorUtil.fail(error, (String)message, (Throwable)ex);
        }
        catch (CoteafsError err) {
            ErrorUtils.logError(err, message);
            throw err;
        }
    }

    private static void logError(Throwable error, String message) {
        StackTraceElement[] traces;
        log.error((Object)error);
        for (StackTraceElement s : traces = error.getStackTrace()) {
            log.error(String.format("\tat %s", s));
        }
        Throwable root = error.getCause();
        if (root != null) {
            log.error("Caused by:");
            ErrorUtils.logError(root, message);
        }
    }

    private ErrorUtils() {
    }
}

