/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.formatter;

import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.github.wasiqb.coteafs.services.error.JsonFormatTransformerError;
import com.github.wasiqb.coteafs.services.formatter.PayloadLogger;
import com.github.wasiqb.coteafs.services.formatter.PayloadType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

class JsonPayloadLogger
implements PayloadLogger {
    JsonPayloadLogger() {
    }

    @Override
    public String[] getPayload(PayloadType type, String body) {
        try {
            JsonParser parser = new JsonParser();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonElement element = parser.parse(body);
            return gson.toJson(element).split("\n");
        }
        catch (Exception e) {
            ErrorUtil.fail(JsonFormatTransformerError.class, (String)"Error while JSON Transformation.", (Throwable)e);
            return new String[0];
        }
    }
}

